/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.Interceptors;
import org.apache.openejb.jee.LocalCollection;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.Relationships;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlRootElement(name="ejb-jar")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ejb-jarType", propOrder={"moduleName", "descriptions", "displayNames", "icon", "enterpriseBeans", "interceptors", "relationships", "assemblyDescriptor", "ejbClientJar"})
public class EjbJar
implements NamedModule {
    @XmlElement(name="module-name")
    protected String moduleName;
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlTransient
    protected TextMap displayName = new TextMap();
    @XmlElement(name="icon", required=true)
    protected LocalCollection<Icon> icon = new LocalCollection();
    @XmlTransient
    protected Map<String, EnterpriseBean> enterpriseBeans = new LinkedHashMap<String, EnterpriseBean>();
    private Interceptors interceptors;
    protected Relationships relationships;
    @XmlElement(name="assembly-descriptor")
    protected AssemblyDescriptor assemblyDescriptor;
    @XmlElement(name="ejb-client-jar")
    protected String ejbClientJar;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlAttribute(name="metadata-complete")
    protected Boolean metadataComplete;
    @XmlAttribute(required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String version;

    public EjbJar() {
    }

    public EjbJar(String id) {
        this.id = id;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    @XmlElement(name="display-name", required=true)
    public Text[] getDisplayNames() {
        return this.displayName.toArray();
    }

    public void setDisplayNames(Text[] text) {
        this.displayName.set(text);
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public Collection<Icon> getIcons() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon;
    }

    public Map<String, Icon> getIconMap() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon.toMap();
    }

    public Icon getIcon() {
        return this.icon.getLocal();
    }

    @XmlElementWrapper(name="enterprise-beans")
    @XmlElements(value={@XmlElement(name="message-driven", required=true, type=MessageDrivenBean.class), @XmlElement(name="session", required=true, type=SessionBean.class), @XmlElement(name="entity", required=true, type=EntityBean.class)})
    public EnterpriseBean[] getEnterpriseBeans() {
        return this.enterpriseBeans.values().toArray(new EnterpriseBean[this.enterpriseBeans.size()]);
    }

    public void setEnterpriseBeans(EnterpriseBean[] v) {
        this.enterpriseBeans.clear();
        for (EnterpriseBean e : v) {
            this.enterpriseBeans.put(e.getEjbName(), e);
        }
    }

    public <T extends EnterpriseBean> T addEnterpriseBean(T bean) {
        this.enterpriseBeans.put(bean.getEjbName(), bean);
        return bean;
    }

    public EnterpriseBean removeEnterpriseBean(String name) {
        EnterpriseBean bean = this.enterpriseBeans.remove(name);
        return bean;
    }

    public EnterpriseBean getEnterpriseBean(String ejbName) {
        return this.enterpriseBeans.get(ejbName);
    }

    public Map<String, EnterpriseBean> getEnterpriseBeansByEjbName() {
        return this.enterpriseBeans;
    }

    public Interceptor[] getInterceptors() {
        if (this.interceptors == null) {
            return new Interceptor[0];
        }
        return this.interceptors.getInterceptor();
    }

    public Interceptor addInterceptor(Interceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new Interceptors();
        }
        return this.interceptors.addInterceptor(interceptor);
    }

    public Interceptor getInterceptor(String className) {
        if (this.interceptors == null) {
            return null;
        }
        return this.interceptors.getInterceptor(className);
    }

    public Relationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(Relationships value) {
        this.relationships = value;
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        if (this.assemblyDescriptor == null) {
            this.assemblyDescriptor = new AssemblyDescriptor();
        }
        return this.assemblyDescriptor;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor value) {
        this.assemblyDescriptor = value;
    }

    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    public void setEjbClientJar(String value) {
        this.ejbClientJar = value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    public Boolean isMetadataComplete() {
        return this.metadataComplete != null && this.metadataComplete != false;
    }

    public void setMetadataComplete(Boolean value) {
        this.metadataComplete = value;
    }

    public String getVersion() {
        if (this.version == null) {
            return "3.0";
        }
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }
}

