/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.derby.client.net.NaiveTrustManager;

public class OpenSocketAction
implements PrivilegedExceptionAction {
    private String server_;
    private int port_;
    private int clientSSLMode_;

    public OpenSocketAction(String string, int n, int n2) {
        this.server_ = string;
        this.port_ = n;
        this.clientSSLMode_ = n2;
    }

    public Object run() throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException {
        SocketFactory socketFactory;
        switch (this.clientSSLMode_) {
            case 1: {
                socketFactory = NaiveTrustManager.getSocketFactory();
                break;
            }
            case 2: {
                socketFactory = SSLSocketFactory.getDefault();
                break;
            }
            case 0: {
                socketFactory = SocketFactory.getDefault();
                break;
            }
            default: {
                socketFactory = SocketFactory.getDefault();
            }
        }
        return socketFactory.createSocket(this.server_, this.port_);
    }
}

