/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.transaction.TransactionManager;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.ControlImpl;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class TransactionFactoryImpl
extends PortableRemoteObject
implements TransactionFactory {
    int timeoutMax = 3600;
    private Vector coordinatorList = new Vector();

    public TransactionFactoryImpl() throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)"default constructor");
        }
    }

    public synchronized Control create(int timeout) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("timeout=" + timeout));
        }
        ControlImpl ctrl = null;
        if (timeout == 0 || timeout > this.timeoutMax) {
            timeout = this.timeoutMax;
        }
        XidImpl xid = new XidImpl("TMServer", 0);
        try {
            ctrl = new ControlImpl(timeout, xid, null);
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", (Throwable)e);
        }
        return ctrl;
    }

    public synchronized Control create(int timeout, Xid xid) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("xid=" + xid));
        }
        ControlImpl ctrl = null;
        if (timeout == 0 || timeout > this.timeoutMax) {
            timeout = this.timeoutMax;
        }
        try {
            ctrl = new ControlImpl(timeout, xid, null);
            InitialContext ictx = new InitialContext();
            TransactionManager tm = (TransactionManager)ictx.lookup("java:/TransactionManager");
            TransactionImpl tx = ((Current)tm).getTxByXid(xid);
            if (tx != null) {
                InternalTransactionContext ctx = new InternalTransactionContext(timeout, ctrl, xid);
                tx.updatePropagationContext(ctx);
            }
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", (Throwable)e);
        }
        return ctrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Control recreate(TransactionContext ctx) throws RemoteException {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("TransactionContext=" + ctx));
        }
        ControlImpl ctrl = null;
        Vector vector = this.coordinatorList;
        synchronized (vector) {
            for (int i = 0; i < this.coordinatorList.size(); ++i) {
                Coordinator coord = (Coordinator)this.coordinatorList.elementAt(i);
                if (!coord.equals(ctx.getCoordinator())) continue;
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"recreate: Control already in the list");
                }
                ctrl = (ControlImpl)coord;
                break;
            }
        }
        if (ctrl != null) {
            if (TraceTm.jotm.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)"recreate twice");
            }
            return ctrl;
        }
        Xid xid = ctx.getXid();
        try {
            ctrl = new ControlImpl(ctx.getTimeout(), xid, ctx.getCoordinator());
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", (Throwable)e);
        }
        return ctrl;
    }

    public int getPortNumber() throws RemoteException {
        return 0;
    }

    public String getHostName() throws RemoteException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new RemoteException("" + e);
        }
    }
}

