/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.security.valve;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.Assembler;
import org.eclipse.virgo.web.enterprise.security.StandardSecurityService;

public class OpenEjbSecurityInitializationValve
extends ValveBase {
    private StandardSecurityService securityService;

    public OpenEjbSecurityInitializationValve() {
        super(true);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object oldState = null;
        Wrapper wrapper = request.getMappingData().wrapper;
        if (this.getSecurityService() != null && wrapper != null) {
            oldState = this.securityService.enterWebApp(wrapper, request.getPrincipal(), wrapper.getRunAs());
        }
        try {
            this.getNext().invoke(request, response);
        }
        catch (Throwable throwable) {
            if (this.securityService != null) {
                this.securityService.exitWebApp(oldState);
            }
            throw throwable;
        }
        if (this.securityService != null) {
            this.securityService.exitWebApp(oldState);
        }
    }

    private StandardSecurityService getSecurityService() {
        if (this.securityService == null) {
            Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
            this.securityService = (StandardSecurityService)assembler.getSecurityService();
        }
        return this.securityService;
    }
}

