/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.io.File;
import java.util.Locale;
import org.eclipse.virgo.kernel.artifact.bundle.BundleBridge;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.HashGenerator;
import org.osgi.framework.Version;

final class WebArtifactIdentityDeterminer
implements ArtifactIdentityDeterminer {
    private static final String WAR_EXTENSION = ".war";
    private final BundleBridge bundleBridge;

    public WebArtifactIdentityDeterminer(HashGenerator hashGenerator) {
        this.bundleBridge = new BundleBridge(hashGenerator);
    }

    public ArtifactIdentity determineIdentity(File file, String scopeName) {
        String fileName = file.getName();
        if (fileName != null && fileName.toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION)) {
            ArtifactDescriptor artifactDescriptor = null;
            try {
                artifactDescriptor = this.bundleBridge.generateArtifactDescriptor(file);
            }
            catch (ArtifactGenerationException artifactGenerationException) {}
            if (artifactDescriptor == null) {
                return new ArtifactIdentity("bundle", this.trimExtension(file), Version.emptyVersion, null);
            }
            return new ArtifactIdentity(artifactDescriptor.getType(), artifactDescriptor.getName(), artifactDescriptor.getVersion(), scopeName);
        }
        return null;
    }

    private String trimExtension(File file) {
        String filename = file.getName();
        int lastIndexOf = filename.lastIndexOf(46);
        if (lastIndexOf > 0) {
            return filename.substring(0, lastIndexOf);
        }
        return filename;
    }
}

