/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.equinox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.virgo.util.math.Sets;

public final class UsesAnalyser {
    public AnalysedUsesConflict[] getUsesConflicts(State state, ResolverError usesError) {
        VersionConstraint constraint = usesError.getUnsatisfiedConstraint();
        ArrayList<AnalysedUsesConflict> analysedUsesConflicts = new ArrayList<AnalysedUsesConflict>();
        if (constraint instanceof ImportPackageSpecification) {
            PackageSources usedPackages;
            ExportPackageDescription exportPackage;
            ImportPackageSpecification rootImport = (ImportPackageSpecification)constraint;
            PackageSources visiblePackages = this.generateExportPackagesVisibleInFailedBundle(state, rootImport);
            ExportPackageDescription[] exportPackageDescriptionArray = this.getResolvedCandidateExports(state, rootImport);
            int n = exportPackageDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                exportPackage = exportPackageDescriptionArray[n2];
                usedPackages = this.generateExportPackagesUsedViaExportPackage(state, exportPackage);
                analysedUsesConflicts.addAll(this.findConflictingExports(usedPackages, visiblePackages));
                ++n2;
            }
            if (analysedUsesConflicts.isEmpty()) {
                exportPackageDescriptionArray = this.getUnresolvedCandidateExports(state, rootImport);
                n = exportPackageDescriptionArray.length;
                n2 = 0;
                while (n2 < n) {
                    exportPackage = exportPackageDescriptionArray[n2];
                    usedPackages = this.generateExportPackagesUsedViaExportPackage(state, exportPackage);
                    analysedUsesConflicts.addAll(this.findConflictingExports(usedPackages, visiblePackages));
                    ++n2;
                }
            }
        }
        return analysedUsesConflicts.toArray(new AnalysedUsesConflict[analysedUsesConflicts.size()]);
    }

    public ResolverError[] getUsesResolverErrors(State state, BundleDescription bundle) {
        ResolverError[] errors = state.getResolverErrors(bundle);
        if (errors != null) {
            ArrayList<ResolverError> usesErrors = new ArrayList<ResolverError>(errors.length);
            ResolverError[] resolverErrorArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                ResolverError re = resolverErrorArray[n2];
                if (re.getType() == 32) {
                    usesErrors.add(re);
                }
                ++n2;
            }
            return usesErrors.toArray(new ResolverError[usesErrors.size()]);
        }
        return null;
    }

    private List<AnalysedUsesConflict> findConflictingExports(PackageSources usedPackages, PackageSources directPackages) {
        ArrayList<AnalysedUsesConflict> usesConflicts = new ArrayList<AnalysedUsesConflict>();
        Set packagesInCommon = Sets.intersection(usedPackages.keySet(), directPackages.keySet());
        for (String packageName : packagesInCommon) {
            Set allUsed = (Set)usedPackages.get(packageName);
            Set allWired = (Set)directPackages.get(packageName);
            for (SourcedPackage sourcedPackage : allUsed) {
                UsedBySourcedPackage usedSourced = (UsedBySourcedPackage)sourcedPackage;
                if (UsesAnalyser.exportDescriptionOccursIn(usedSourced.getSource(), allWired)) continue;
                for (SourcedPackage sp : allWired) {
                    usesConflicts.add(new AnalysedUsesConflict(usedSourced, sp));
                }
            }
        }
        return usesConflicts;
    }

    private static final boolean exportDescriptionOccursIn(ExportPackageDescription source, Set<SourcedPackage> allWired) {
        for (SourcedPackage w : allWired) {
            if (!w.getSource().equals(source)) continue;
            return true;
        }
        return false;
    }

    private PackageSources generateExportPackagesUsedViaExportPackage(State state, ExportPackageDescription exportPackage) {
        PackageSources usedPackages = this.constructEmptyPackageSources();
        HashSet<String> knownPackages = new HashSet<String>();
        this.addUsedImportedPackages(state, usedPackages, exportPackage, exportPackage, knownPackages);
        return usedPackages;
    }

    private PackageSources generateExportPackagesVisibleInFailedBundle(State state, ImportPackageSpecification rootImport) {
        PackageSources visiblePackages = this.getOtherImportedPackages(state, rootImport);
        visiblePackages.putAll(this.computeUsesClosure(state, visiblePackages));
        BundleDescription failedBundle = rootImport.getBundle();
        visiblePackages.putAll(this.getExportedPackages(failedBundle));
        return visiblePackages;
    }

    private PackageSources computeUsesClosure(State state, PackageSources packages) {
        PackageSources additionalPackages = this.constructEmptyPackageSources();
        Set keys = packages.entrySet();
        HashSet<String> knownPackages = new HashSet<String>();
        for (Map.Entry key : keys) {
            for (SourcedPackage sp : (Set)key.getValue()) {
                ExportPackageDescription source = sp.getSource();
                this.addUsedImportedPackages(state, additionalPackages, source, source, knownPackages);
            }
        }
        return additionalPackages;
    }

    private ExportPackageDescription[] getResolvedCandidateExports(State state, ImportPackageSpecification rootImport) {
        ArrayList<ExportPackageDescription> exports = new ArrayList<ExportPackageDescription>();
        BundleDescription[] bundles = state.getResolvedBundles();
        if (bundles != null) {
            BundleDescription[] bundleDescriptionArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundle = bundleDescriptionArray[n2];
                ExportPackageDescription[] exportPackageDescriptionArray = bundle.getExportPackages();
                int n3 = exportPackageDescriptionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportPackage = exportPackageDescriptionArray[n4];
                    if (rootImport.isSatisfiedBy((BaseDescription)exportPackage)) {
                        exports.add(exportPackage);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return exports.toArray(new ExportPackageDescription[exports.size()]);
    }

    private ExportPackageDescription[] getUnresolvedCandidateExports(State state, ImportPackageSpecification rootImport) {
        ArrayList<ExportPackageDescription> exports = new ArrayList<ExportPackageDescription>();
        BundleDescription[] resolvedBundles = state.getResolvedBundles();
        BundleDescription[] bundles = state.getBundles();
        if (bundles != null) {
            BundleDescription[] bundleDescriptionArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundle = bundleDescriptionArray[n2];
                if (UsesAnalyser.notInArray(bundle, resolvedBundles)) {
                    ExportPackageDescription[] exportPackageDescriptionArray = bundle.getExportPackages();
                    int n3 = exportPackageDescriptionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExportPackageDescription exportPackage = exportPackageDescriptionArray[n4];
                        if (rootImport.isSatisfiedBy((BaseDescription)exportPackage)) {
                            exports.add(exportPackage);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return exports.toArray(new ExportPackageDescription[exports.size()]);
    }

    private static final boolean notInArray(BundleDescription bundle, BundleDescription[] resolvedBundles) {
        if (resolvedBundles == null) {
            return true;
        }
        BundleDescription[] bundleDescriptionArray = resolvedBundles;
        int n = resolvedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription b = bundleDescriptionArray[n2];
            if (b == bundle) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void addUsedImportedPackages(State state, PackageSources packages, ExportPackageDescription exportPackage, ExportPackageDescription topDependency, Set<String> knownPackages) {
        String[] packageNames = (String[])exportPackage.getDirective("uses");
        if (packageNames != null) {
            BundleDescription bundle = exportPackage.getExporter();
            ExportPackageDescription[] allExports = bundle.getExportPackages();
            ImportPackageSpecification[] allImports = bundle.getImportPackages();
            ExportPackageDescription[] allResolvedImports = bundle.getResolvedImports();
            String[] stringArray = packageNames;
            int n = packageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                ExportPackageDescription localExport = UsesAnalyser.findExportPackageDescriptionInArray(allExports, packageName);
                if (localExport != null) {
                    packages.addPackageSource(packageName, new UsedBySourcedPackage(topDependency, localExport));
                }
                if (!knownPackages.contains(packageName)) {
                    ExportPackageDescription localResolvedImport = UsesAnalyser.findExportPackageDescriptionInArray(allResolvedImports, packageName);
                    if (localResolvedImport != null) {
                        knownPackages.add(packageName);
                        packages.addPackageSource(packageName, new UsedBySourcedPackage(topDependency, localResolvedImport));
                        this.addUsedImportedPackages(state, packages, localResolvedImport, topDependency, knownPackages);
                    } else {
                        ExportPackageDescription[] matchingExports;
                        ImportPackageSpecification anImport = UsesAnalyser.findImportPackageSpecificationInArray(allImports, packageName);
                        if (anImport != null && (matchingExports = this.getCandidateExports(state, anImport)).length != 0) {
                            knownPackages.add(packageName);
                            ExportPackageDescription[] exportPackageDescriptionArray = matchingExports;
                            int n3 = matchingExports.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                ExportPackageDescription matchingExport = exportPackageDescriptionArray[n4];
                                packages.addPackageSource(packageName, new UsedBySourcedPackage(topDependency, matchingExport));
                                this.addUsedImportedPackages(state, packages, matchingExport, topDependency, knownPackages);
                                ++n4;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static final ImportPackageSpecification findImportPackageSpecificationInArray(ImportPackageSpecification[] allImports, String packageName) {
        ImportPackageSpecification[] importPackageSpecificationArray = allImports;
        int n = allImports.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification ips = importPackageSpecificationArray[n2];
            if (packageName.equals(ips.getName())) {
                return ips;
            }
            ++n2;
        }
        return null;
    }

    private static final ExportPackageDescription findExportPackageDescriptionInArray(ExportPackageDescription[] allExports, String packageName) {
        ExportPackageDescription[] exportPackageDescriptionArray = allExports;
        int n = allExports.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription epd = exportPackageDescriptionArray[n2];
            if (packageName.equals(epd.getName())) {
                return epd;
            }
            ++n2;
        }
        return null;
    }

    private PackageSources getOtherImportedPackages(State state, ImportPackageSpecification rootImport) {
        ImportPackageSpecification[] importSpecifications;
        BundleDescription bundle = rootImport.getBundle();
        PackageSources packages = this.constructEmptyPackageSources();
        ImportPackageSpecification[] importPackageSpecificationArray = importSpecifications = bundle.getImportPackages();
        int n = importSpecifications.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importSpecification = importPackageSpecificationArray[n2];
            if (rootImport != importSpecification && !"optional".equals(importSpecification.getDirective("resolution"))) {
                ExportPackageDescription[] exportPackages;
                ExportPackageDescription[] exportPackageDescriptionArray = exportPackages = this.getCandidateExports(state, importSpecification);
                int n3 = exportPackages.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportPackage = exportPackageDescriptionArray[n4];
                    packages.addPackageSource(exportPackage.getName(), new ImportedSourcedPackage(rootImport, exportPackage));
                    ++n4;
                }
            }
            ++n2;
        }
        return packages;
    }

    private ExportPackageDescription[] getCandidateExports(State state, ImportPackageSpecification importSpecification) {
        ExportPackageDescription[] pkgs = this.getResolvedCandidateExports(state, importSpecification);
        if (pkgs.length == 0) {
            pkgs = this.getUnresolvedCandidateExports(state, importSpecification);
        }
        return pkgs;
    }

    private PackageSources getExportedPackages(BundleDescription bundle) {
        ExportPackageDescription[] packageArray = bundle.getExportPackages();
        PackageSources packages = this.constructEmptyPackageSources();
        if (packageArray != null) {
            ExportPackageDescription[] exportPackageDescriptionArray = packageArray;
            int n = packageArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription exportPackage = exportPackageDescriptionArray[n2];
                packages.addPackageSource(exportPackage.getName(), new SourcedPackage(exportPackage));
                ++n2;
            }
        }
        return packages;
    }

    private static final String stringOf(ExportPackageDescription source) {
        BundleDescription bundle = source.getSupplier();
        StringBuilder sb = new StringBuilder("'");
        sb.append(source.getName()).append("_").append(source.getVersion()).append("' in bundle ").append(UsesAnalyser.stringOf(bundle));
        return sb.toString();
    }

    private static final String stringOf(BundleDescription bundle) {
        StringBuilder sb = new StringBuilder("'");
        sb.append(bundle.getSymbolicName()).append("_").append(bundle.getVersion()).append("[").append(bundle.getBundleId()).append("]").append("'");
        return sb.toString();
    }

    private PackageSources constructEmptyPackageSources() {
        return new PackageSourcesImpl();
    }

    public static final class AnalysedUsesConflict {
        private final UsedBySourcedPackage usedPackage;
        private final SourcedPackage resolvedPackage;

        private AnalysedUsesConflict(UsedBySourcedPackage used, SourcedPackage resolved) {
            this.usedPackage = used;
            this.resolvedPackage = resolved;
        }

        public String[] getConflictStatement() {
            return new String[]{"package        " + this.usedPackage.toString(), "conflicts with " + this.resolvedPackage.toString()};
        }

        public ExportPackageDescription getConflictingPackage() {
            return this.usedPackage == null ? null : this.usedPackage.getSource();
        }

        public ExportPackageDescription getUsesRootPackage() {
            return this.usedPackage == null ? null : this.usedPackage.getUsedBy();
        }

        public ExportPackageDescription getPackage() {
            return this.resolvedPackage == null ? null : this.resolvedPackage.getSource();
        }
    }

    public static enum CollisionReason {
        DISJOINT_VERSION_RANGES,
        ATTRIBUTE_MISMATCH;

    }

    public static interface DependentConstraintCollision {
        public ImportPackageSpecification getConsumerConstraint();

        public ImportPackageSpecification getSupplierConstraint();

        public CollisionReason getCollisionReason();
    }

    private static final class ImportedSourcedPackage
    extends SourcedPackage {
        private final ImportPackageSpecification rootImport;

        public ImportedSourcedPackage(ImportPackageSpecification rootImport, ExportPackageDescription source) {
            super(source);
            this.rootImport = rootImport;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(" imported by bundle ").append(UsesAnalyser.stringOf(this.rootImport.getBundle()));
            return sb.toString();
        }
    }

    private static interface PackageSources
    extends Map<String, Set<SourcedPackage>> {
        public void addPackageSource(String var1, SourcedPackage var2);
    }

    private class PackageSourcesImpl
    extends HashMap<String, Set<SourcedPackage>>
    implements PackageSources {
        private static final long serialVersionUID = 1L;

        private PackageSourcesImpl() {
        }

        @Override
        public final void addPackageSource(String packageName, SourcedPackage sourcedPackage) {
            HashSet<SourcedPackage> sourcedSet = (HashSet<SourcedPackage>)this.get(packageName);
            if (sourcedSet == null) {
                sourcedSet = new HashSet<SourcedPackage>();
                this.put(packageName, sourcedSet);
            }
            sourcedSet.add(sourcedPackage);
        }
    }

    public static interface PossibleMatch {
        public ExportPackageDescription getSupplier();

        public boolean isDependentConstraintMismatch();

        public DependentConstraintCollision[] getCollisions();
    }

    private static class SourcedPackage {
        private final ExportPackageDescription source;

        public SourcedPackage(ExportPackageDescription source) {
            this.source = source;
        }

        public String toString() {
            return UsesAnalyser.stringOf(this.source);
        }

        public ExportPackageDescription getSource() {
            return this.source;
        }
    }

    private static final class UsedBySourcedPackage
    extends SourcedPackage {
        private final ExportPackageDescription usedBy;

        public UsedBySourcedPackage(ExportPackageDescription usedBy, ExportPackageDescription source) {
            super(source);
            this.usedBy = usedBy;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(" used by ").append(UsesAnalyser.stringOf(this.usedBy));
            return sb.toString();
        }

        public ExportPackageDescription getUsedBy() {
            return this.usedBy;
        }
    }

    public static interface UsesViolation {
        public VersionConstraint getConstraint();

        public PossibleMatch[] getPossibleMatches();
    }
}

