/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.QxDimension;
import org.eclipse.rap.rwt.internal.theme.QxType;

public class QxBorder
implements QxType {
    public static final QxBorder NONE = new QxBorder(0, null, null);
    private static final String[] VALID_STYLES = new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"};
    public final int width;
    public final String style;
    public final String color;

    private QxBorder(int width, String style, String color) {
        this.width = width;
        this.style = style;
        this.color = color;
    }

    public static QxBorder create(int width, String style, String color) {
        QxBorder result = width == 0 || "none".equals(style) || "hidden".equals(style) ? NONE : new QxBorder(width, style == null ? "solid" : style, color);
        return result;
    }

    public static QxBorder valueOf(String input) {
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        String[] parts = input.split("\\s+");
        if (input.trim().length() == 0) {
            throw new IllegalArgumentException("Empty border definition");
        }
        if (parts.length > 3) {
            throw new IllegalArgumentException("Illegal number of arguments for border");
        }
        int width = -1;
        String style = null;
        String color = null;
        int i = 0;
        while (i < parts.length) {
            String parsedStyle;
            Integer parsedWidth;
            String part = parts[i];
            boolean consumed = "".equals(part);
            if (!consumed && width == -1 && (parsedWidth = QxDimension.parseLength(part)) != null) {
                if (parsedWidth < 0) {
                    throw new IllegalArgumentException("Negative width: " + part);
                }
                width = parsedWidth;
                consumed = true;
            }
            if (!consumed && style == null && (parsedStyle = QxBorder.parseStyle(part)) != null) {
                style = parsedStyle;
                consumed = true;
            }
            if (!consumed && color == null) {
                color = part;
                consumed = true;
            }
            if (!consumed) {
                throw new IllegalArgumentException("Illegal parameter for color: " + part);
            }
            ++i;
        }
        if (width == -1) {
            width = 1;
        }
        return QxBorder.create(width, style, color);
    }

    public String toDefaultString() {
        String result;
        if (this.width == 0) {
            result = "none";
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.width);
            buffer.append("px ");
            buffer.append(this.style);
            if (this.color != null) {
                buffer.append(" ");
                buffer.append(this.color);
            }
            result = buffer.toString();
        }
        return result;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxBorder) {
            QxBorder other = (QxBorder)object;
            result = other.width == this.width && (this.style == null ? other.style == null : this.style.equals(other.style)) && (this.color == null ? other.color == null : this.color.equals(other.color));
        }
        return result;
    }

    public int hashCode() {
        int result = 23;
        result += 37 * result + this.width;
        if (this.style != null) {
            result += 37 * result + this.style.hashCode();
        }
        if (this.color != null) {
            result += 37 * result + this.color.hashCode();
        }
        return result;
    }

    public String toString() {
        return "QxBorder{ " + this.width + ", " + this.style + ", " + this.color + " }";
    }

    private static String parseStyle(String part) {
        String result = null;
        int j = 0;
        while (j < VALID_STYLES.length && result == null) {
            if (VALID_STYLES[j].equalsIgnoreCase(part)) {
                result = VALID_STYLES[j];
            }
            ++j;
        }
        return result;
    }
}

