/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class CacheInterceptorMetadata
extends ORMetadata {
    protected MetadataClass m_interceptorClass;
    protected String m_interceptorClassName;

    public CacheInterceptorMetadata() {
        super("<cache-interceptor>");
    }

    public CacheInterceptorMetadata(MetadataAnnotation cacheInterceptor, MetadataAccessor accessor) {
        super(cacheInterceptor, accessor);
        this.m_interceptorClass = this.getMetadataClass((String)cacheInterceptor.getAttribute("value"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CacheInterceptorMetadata) {
            CacheInterceptorMetadata cacheInterceptor = (CacheInterceptorMetadata)objectToCompare;
            return this.valuesMatch(this.m_interceptorClassName, cacheInterceptor.getInterceptorClassName());
        }
        return false;
    }

    public String getInterceptorClassName() {
        return this.m_interceptorClassName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_interceptorClass = this.initXMLClassName(this.m_interceptorClassName);
    }

    public void process(MetadataDescriptor descriptor, MetadataClass javaClass) {
        descriptor.setHasCacheInterceptor();
        descriptor.getClassDescriptor().setCacheInterceptorClassName(this.m_interceptorClass.getName());
    }

    public void setInterceptorClassName(String interceptorClass) {
        this.m_interceptorClassName = interceptorClass;
    }
}

