/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.classloader;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

public class DefaultClassLoaderConfigurer
implements ClassLoaderConfigurer {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, DefaultClassLoaderConfigurer.class);
    private URL[] added = new URL[0];
    private Filter excluded = FalseFilter.INSTANCE;

    @Override
    public URL[] additionalURLs() {
        return this.added;
    }

    @Override
    public boolean accept(URL url) {
        try {
            File file = URLs.toFile(url);
            return !this.excluded.accept(file.getName());
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
    }

    public void setAddedFolder(String addedFolder) {
        File[] files;
        File parent;
        ArrayList<String> addedList = new ArrayList<String>();
        if (addedFolder != null && (parent = new File(addedFolder)).exists() && (files = parent.listFiles()) != null) {
            for (File f : files) {
                String name = f.getName();
                if (!f.isDirectory() && !name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                addedList.add(f.getAbsolutePath());
            }
        }
        this.added = new URL[addedList.size()];
        int i = 0;
        for (String path : addedList) {
            try {
                this.added[i++] = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warning("Can't add file " + path, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcludedListFile(String excludedListFile) {
        File excludedFile;
        String[] excludedPrefixes = null;
        if (excludedListFile != null && (excludedFile = new File(excludedListFile)).exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(excludedFile);
                excludedPrefixes = NewLoaderLogic.readInputStreamList(is);
            }
            catch (FileNotFoundException e) {
                try {
                    LOGGER.error("can't read " + excludedListFile);
                }
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
                IO.close((Closeable)is);
            }
            IO.close((Closeable)is);
        }
        this.excluded = excludedPrefixes == null || excludedPrefixes.length == 0 ? TrueFilter.INSTANCE : Filters.prefixes(excludedPrefixes);
    }

    private static class FalseFilter
    implements Filter {
        public static final FalseFilter INSTANCE = new FalseFilter();

        private FalseFilter() {
        }

        public boolean accept(String name) {
            return true;
        }
    }

    private static class TrueFilter
    implements Filter {
        public static final TrueFilter INSTANCE = new TrueFilter();

        private TrueFilter() {
        }

        public boolean accept(String name) {
            return true;
        }
    }
}

