/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.derby.client.ClientDataSourceFactory;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.shared.common.error.ExceptionUtil;

public abstract class ClientBaseDataSource
implements Serializable,
Referenceable {
    private static final long serialVersionUID = -7660172643035173692L;
    static final boolean SUPPORTS_EUSRIDPWD;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private String databaseName;
    private String description;
    private String dataSourceName;
    private int portNumber = 1527;
    public static final int propertyDefault_portNumber = 1527;
    private String serverName = "localhost";
    public static final String propertyDefault_serverName = "localhost";
    public static final int SSL_OFF = 0;
    private static final String SSL_OFF_STR = "off";
    public static final int SSL_BASIC = 1;
    private static final String SSL_BASIC_STR = "basic";
    public static final int SSL_PEER_AUTHENTICATION = 2;
    private static final String SSL_PEER_AUTHENTICATION_STR = "peerAuthentication";
    private String user = "APP";
    public static final String propertyDefault_user = "APP";
    private static final short SECMEC_HAS_NOT_EXPLICITLY_SET = 0;
    protected short securityMechanism = 0;
    public static final short propertyDefault_securityMechanism = 4;
    private boolean retrieveMessageText = true;
    public static final boolean propertyDefault_retrieveMessageText = true;
    private String traceFile;
    private transient int traceFileSuffixIndex_ = 0;
    private String traceDirectory;
    private boolean traceFileAppend = false;
    public static final boolean propertyDefault_traceFileAppend = false;
    private String password;
    public static final short USER_ONLY_SECURITY = 4;
    public static final short CLEAR_TEXT_PASSWORD_SECURITY = 3;
    public static final short ENCRYPTED_PASSWORD_SECURITY = 7;
    public static final short ENCRYPTED_USER_AND_PASSWORD_SECURITY = 9;
    public static final short STRONG_PASSWORD_SUBSTITUTE_SECURITY = 8;
    private int sslMode;
    private boolean createDatabase;
    private boolean shutdownDatabase;
    protected String connectionAttributes = null;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_CONNECTION_CALLS = 1;
    public static final int TRACE_STATEMENT_CALLS = 2;
    public static final int TRACE_RESULT_SET_CALLS = 4;
    public static final int TRACE_DRIVER_CONFIGURATION = 16;
    public static final int TRACE_CONNECTS = 32;
    public static final int TRACE_PROTOCOL_FLOWS = 64;
    public static final int TRACE_RESULT_SET_META_DATA = 128;
    public static final int TRACE_PARAMETER_META_DATA = 256;
    public static final int TRACE_DIAGNOSTICS = 512;
    public static final int TRACE_XA_CALLS = 2048;
    public static final int TRACE_ALL = -1;
    public static final int propertyDefault_traceLevel = -1;
    protected int traceLevel = -1;
    static /* synthetic */ Class class$java$lang$String;

    ClientBaseDataSource() {
    }

    public synchronized void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public static final int getSSLModeFromString(String string) throws SqlException {
        if (string != null) {
            if (string.equalsIgnoreCase(SSL_OFF_STR)) {
                return 0;
            }
            if (string.equalsIgnoreCase(SSL_BASIC_STR)) {
                return 1;
            }
            if (string.equalsIgnoreCase(SSL_PEER_AUTHENTICATION_STR)) {
                return 2;
            }
            throw new SqlException(null, new ClientMessageId("XJ05B.C"), (Object)"ssl", (Object)string, "off, basic, peerAuthentication");
        }
        return 0;
    }

    public static final int getClientSSLMode(Properties properties) throws SqlException {
        return ClientBaseDataSource.getSSLModeFromString(properties.getProperty("ssl"));
    }

    public static String getUser(Properties properties) {
        String string = properties.getProperty("user");
        return ClientBaseDataSource.parseString(string, propertyDefault_user);
    }

    public static short getSecurityMechanism(Properties properties) {
        short s;
        String string = properties.getProperty("securityMechanism");
        if (string != null) {
            s = Short.parseShort(string);
        } else {
            String string2 = properties.getProperty("password");
            s = ClientBaseDataSource.getUpgradedSecurityMechanism(string2);
        }
        return s;
    }

    public static short getUpgradedSecurityMechanism(String string) {
        if (string == null) {
            return 4;
        }
        return 3;
    }

    public static boolean getRetrieveMessageText(Properties properties) {
        String string = properties.getProperty("retrieveMessageText");
        return ClientBaseDataSource.parseBoolean(string, true);
    }

    public static String getTraceFile(Properties properties) {
        return properties.getProperty("traceFile");
    }

    public static String getTraceDirectory(Properties properties) {
        String string = ClientBaseDataSource.readSystemProperty("derby.client.traceDirectory");
        if (string == null) {
            return properties.getProperty("traceDirectory");
        }
        return string;
    }

    private static String readSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
        });
    }

    public static boolean getTraceFileAppend(Properties properties) {
        String string = properties.getProperty("traceFileAppend");
        return ClientBaseDataSource.parseBoolean(string, false);
    }

    public static String getPassword(Properties properties) {
        return properties.getProperty("password");
    }

    public final synchronized void setPassword(String string) {
        this.password = string;
    }

    public final String getPassword() {
        return this.password;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), ClientDataSourceFactory.class.getName(), null);
        this.addBeanProperties(reference);
        return reference;
    }

    private void addBeanProperties(Reference reference) {
        Method[] methodArray = this.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            String string;
            Method method = methodArray[i];
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || (string = method.getName()).length() < 5 || !string.startsWith("get") || !Integer.TYPE.equals(clazz = method.getReturnType()) && !Short.TYPE.equals(clazz) && !(class$java$lang$String == null ? ClientBaseDataSource.class$("java.lang.String") : class$java$lang$String).equals(clazz) && !Boolean.TYPE.equals(clazz)) continue;
            String string2 = string.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(string.substring(4));
            try {
                Object object = method.invoke((Object)this, null);
                if (object == null) continue;
                reference.add(new StringRefAddr(string2, object.toString()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    LogWriter computeDncLogWriterForNewConnection(String string) throws SqlException {
        return ClientBaseDataSource.computeDncLogWriterForNewConnection(this.logWriter, this.traceDirectory, this.traceFile, this.traceFileAppend, this.traceLevel, string, this.traceFileSuffixIndex_++);
    }

    static LogWriter computeDncLogWriterForNewConnection(PrintWriter printWriter, String string, String string2, boolean bl, int n, String string3, int n2) throws SqlException {
        int n3 = Configuration.traceFileSuffixIndex__++;
        LogWriter logWriter = ClientBaseDataSource.computeDncLogWriter(printWriter, string, string2, bl, string3, n2, n);
        if (logWriter != null) {
            return logWriter;
        }
        logWriter = ClientBaseDataSource.computeDncLogWriter(null, Configuration.traceDirectory__, Configuration.traceFile__, Configuration.traceFileAppend__, "_global", n3, Configuration.traceLevel__);
        return logWriter;
    }

    static LogWriter computeDncLogWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n, int n2) throws SqlException {
        if (n2 == 0) {
            return null;
        }
        PrintWriter printWriter2 = ClientBaseDataSource.computePrintWriter(printWriter, string, string2, bl, string3, n);
        if (printWriter2 == null) {
            return null;
        }
        NetLogWriter netLogWriter = new NetLogWriter(printWriter2, n2);
        if (printWriter2 != printWriter && (string != null || string2 != null)) {
            netLogWriter.printWriterNeedsToBeClosed_ = true;
        }
        return netLogWriter;
    }

    public static LogWriter computeDncLogWriter(Connection connection, PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n, int n2) throws SqlException {
        if (n2 == 0) {
            return null;
        }
        PrintWriter printWriter2 = ClientBaseDataSource.computePrintWriter(printWriter, string, string2, bl, string3, n);
        if (printWriter2 == null) {
            return null;
        }
        LogWriter logWriter = connection.agent_.newLogWriter_(printWriter2, n2);
        if (printWriter2 != printWriter && (string != null || string2 != null)) {
            logWriter.printWriterNeedsToBeClosed_ = true;
        }
        return logWriter;
    }

    static PrintWriter computePrintWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n) throws SqlException {
        if (printWriter != null) {
            return printWriter;
        }
        if (string != null) {
            String string4 = string2 == null ? string + File.separator + string3 + "_" + n : string + File.separator + string2 + string3 + "_" + n;
            return LogWriter.getPrintWriter(string4, true);
        }
        if (string2 != null) {
            return LogWriter.getPrintWriter(string2, bl);
        }
        return null;
    }

    private static boolean parseBoolean(String string, boolean bl) {
        if (string != null) {
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        return bl;
    }

    private static String parseString(String string, String string2) {
        if (string != null) {
            return string;
        }
        return string2;
    }

    private static short parseShort(String string, short s) {
        if (string != null) {
            return Short.parseShort(string);
        }
        return s;
    }

    private static int parseInt(String string, int n) {
        if (string != null) {
            return Integer.parseInt(string);
        }
        return n;
    }

    static Properties tokenizeAttributes(String string, Properties properties) throws SqlException {
        if (string == null) {
            return properties;
        }
        Properties properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    throw new SqlException(null, new ClientMessageId("XJ212.S"), string);
                }
                properties2.setProperty(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, new ClientMessageId("XJ212.S"), (Object)string, (Throwable)noSuchElementException);
        }
        ClientBaseDataSource.checkBoolean(properties2, "retrieveMessageText");
        return properties2;
    }

    private static void checkBoolean(Properties properties, String string) throws SqlException {
        String[] stringArray = new String[]{"true", "false"};
        ClientBaseDataSource.checkEnumeration(properties, string, stringArray);
    }

    private static void checkEnumeration(Properties properties, String string, String[] stringArray) throws SqlException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.toUpperCase(Locale.ENGLISH).equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        String string3 = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string3 = string3 + "|";
            }
            string3 = string3 + stringArray[i];
        }
        throw new SqlException(null, new ClientMessageId("XJ05B.C"), (Object)string, (Object)string2, string3);
    }

    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setPortNumber(int n) {
        this.portNumber = n;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized void setRetrieveMessageText(boolean bl) {
        this.retrieveMessageText = bl;
    }

    public boolean getRetrieveMessageText() {
        return this.retrieveMessageText;
    }

    public synchronized void setSecurityMechanism(short s) {
        this.securityMechanism = s;
    }

    public short getSecurityMechanism() {
        return this.getSecurityMechanism(this.getPassword());
    }

    public short getSecurityMechanism(String string) {
        if (this.securityMechanism == 0) {
            return ClientBaseDataSource.getUpgradedSecurityMechanism(string);
        }
        return this.securityMechanism;
    }

    public void setSsl(String string) throws SqlException {
        this.sslMode = ClientBaseDataSource.getSSLModeFromString(string);
    }

    public String getSsl() {
        switch (this.sslMode) {
            default: {
                return SSL_OFF_STR;
            }
            case 1: {
                return SSL_BASIC_STR;
            }
            case 2: 
        }
        return SSL_PEER_AUTHENTICATION_STR;
    }

    public final void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.equalsIgnoreCase("create");
    }

    public final String getCreateDatabase() {
        String string = null;
        if (this.createDatabase) {
            string = "create";
        }
        return string;
    }

    public final void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase("shutdown");
    }

    public final String getShutdownDatabase() {
        String string = null;
        if (this.shutdownDatabase) {
            string = "shutdown";
        }
        return string;
    }

    public final void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public static int getTraceLevel(Properties properties) {
        String string = ClientBaseDataSource.readSystemProperty("derby.client.traceLevel");
        if (string == null) {
            string = properties.getProperty("traceLevel");
        }
        return ClientBaseDataSource.parseInt(string, -1);
    }

    public synchronized void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public synchronized void setTraceFile(String string) {
        this.traceFile = string;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public synchronized void setTraceDirectory(String string) {
        this.traceDirectory = string;
    }

    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    public synchronized void setTraceFileAppend(boolean bl) {
        this.traceFileAppend = bl;
    }

    public boolean getTraceFileAppend() {
        return this.traceFileAppend;
    }

    public int maxStatementsToPool() {
        return 0;
    }

    void updateDataSourceValues(Properties properties) throws SqlException {
        if (properties == null) {
            return;
        }
        if (properties.containsKey("user")) {
            this.setUser(ClientBaseDataSource.getUser(properties));
        }
        if (properties.containsKey("securityMechanism")) {
            this.setSecurityMechanism(ClientBaseDataSource.getSecurityMechanism(properties));
        }
        if (properties.containsKey("traceFile")) {
            this.setTraceFile(ClientBaseDataSource.getTraceFile(properties));
        }
        if (properties.containsKey("traceDirectory")) {
            this.setTraceDirectory(ClientBaseDataSource.getTraceDirectory(properties));
        }
        if (properties.containsKey("traceFileAppend")) {
            this.setTraceFileAppend(ClientBaseDataSource.getTraceFileAppend(properties));
        }
        if (properties.containsKey("retrieveMessageText")) {
            this.setRetrieveMessageText(ClientBaseDataSource.getRetrieveMessageText(properties));
        }
        if (properties.containsKey("ssl")) {
            this.sslMode = ClientBaseDataSource.getClientSSLMode(properties);
        }
    }

    protected final void handleConnectionException(LogWriter logWriter, SqlException sqlException) throws SQLException {
        if (sqlException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ212.S"))) {
            throw new SqlException(logWriter, new ClientMessageId("XJ028.C"), (Object)this.constructUrl(), (Throwable)sqlException).getSQLException();
        }
    }

    private String constructUrl() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("jdbc:derby://");
        stringBuffer.append(this.serverName);
        stringBuffer.append(':');
        stringBuffer.append(this.portNumber);
        stringBuffer.append('/');
        stringBuffer.append(this.databaseName);
        if (this.connectionAttributes != null) {
            stringBuffer.append(';');
            stringBuffer.append(this.connectionAttributes);
        }
        return stringBuffer.toString();
    }

    static {
        boolean bl = false;
        try {
            new EncryptionManager(null);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        SUPPORTS_EUSRIDPWD = bl;
    }
}

