/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import org.quartz.Trigger;
import org.quartz.simpl.JobWrapper;

class TriggerWrapper {
    public String key;
    public String jobKey;
    public Trigger trigger;
    public int state = 0;
    public static final int STATE_WAITING = 0;
    public static final int STATE_ACQUIRED = 1;
    public static final int STATE_EXECUTING = 2;
    public static final int STATE_COMPLETE = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_BLOCKED = 5;
    public static final int STATE_PAUSED_BLOCKED = 6;
    public static final int STATE_ERROR = 7;

    TriggerWrapper(Trigger trigger) {
        this.trigger = trigger;
        this.key = TriggerWrapper.getTriggerNameKey(trigger);
        this.jobKey = JobWrapper.getJobNameKey(trigger.getJobName(), trigger.getJobGroup());
    }

    static String getTriggerNameKey(Trigger trigger) {
        return trigger.getGroup() + "_$x$x$_" + trigger.getName();
    }

    static String getTriggerNameKey(String triggerName, String groupName) {
        return groupName + "_$x$x$_" + triggerName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TriggerWrapper) {
            TriggerWrapper tw = (TriggerWrapper)obj;
            if (tw.key.equals(this.key)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public Trigger getTrigger() {
        return this.trigger;
    }
}

