/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.listeners;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public class FilterAndBroadcastJobListener
implements JobListener {
    private String name;
    private List listeners;
    private List namePatterns = new LinkedList();
    private List groupPatterns = new LinkedList();

    public FilterAndBroadcastJobListener(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Listener name cannot be null!");
        }
        this.name = name;
        this.listeners = new LinkedList();
    }

    public FilterAndBroadcastJobListener(String name, List listeners) {
        this(name);
        this.listeners.addAll(listeners);
    }

    public String getName() {
        return this.name;
    }

    public void addListener(JobListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(JobListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeListener(String listenerName) {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = (JobListener)itr.next();
            if (!jl.getName().equals(listenerName)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public List getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void addJobNamePattern(String regularExpression) {
        if (regularExpression == null) {
            throw new IllegalArgumentException("Expression cannot be null!");
        }
        this.namePatterns.add(regularExpression);
    }

    public List getJobNamePatterns() {
        return this.namePatterns;
    }

    public void addJobGroupPattern(String regularExpression) {
        if (regularExpression == null) {
            throw new IllegalArgumentException("Expression cannot be null!");
        }
        this.groupPatterns.add(regularExpression);
    }

    public List getJobGroupPatterns() {
        return this.namePatterns;
    }

    protected boolean shouldDispatch(JobExecutionContext context) {
        String pat;
        JobDetail job = context.getJobDetail();
        if (this.namePatterns.size() == 0 && this.groupPatterns.size() == 0) {
            return true;
        }
        Iterator itr = this.groupPatterns.iterator();
        while (itr.hasNext()) {
            pat = (String)itr.next();
            if (!job.getGroup().matches(pat)) continue;
            return true;
        }
        itr = this.namePatterns.iterator();
        while (itr.hasNext()) {
            pat = (String)itr.next();
            if (!job.getName().matches(pat)) continue;
            return true;
        }
        return false;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (!this.shouldDispatch(context)) {
            return;
        }
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = (JobListener)itr.next();
            jl.jobToBeExecuted(context);
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        if (!this.shouldDispatch(context)) {
            return;
        }
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = (JobListener)itr.next();
            jl.jobExecutionVetoed(context);
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        if (!this.shouldDispatch(context)) {
            return;
        }
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            JobListener jl = (JobListener)itr.next();
            jl.jobWasExecuted(context, jobException);
        }
    }
}

