/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.dbcp;

import java.lang.reflect.Field;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.openejb.resource.jdbc.DataSourceHelper;
import org.apache.openejb.resource.jdbc.dbcp.BasicManagedDataSource;

public class DbcpManagedDataSource
extends BasicManagedDataSource {
    private final DataSource ds;

    public DbcpManagedDataSource(String name, DataSource dataSource) {
        super(name);
        this.ds = dataSource;
    }

    @Override
    public void setJdbcUrl(String url) {
        try {
            DataSourceHelper.setUrl(this.ds, url);
        }
        catch (Throwable e1) {
            super.setUrl(url);
        }
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.ds instanceof XADataSource) {
            XADataSource xaDataSourceInstance = (XADataSource)((Object)this.ds);
            DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.getTransactionManager(), xaDataSourceInstance, this.username, this.password);
            this.setTransactionRegistry(xaConnectionFactory.getTransactionRegistry());
            return xaConnectionFactory;
        }
        DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(this.ds, this.username, this.password);
        LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), (ConnectionFactory)connectionFactory);
        this.setTransactionRegistry(xaConnectionFactory.getTransactionRegistry());
        return xaConnectionFactory;
    }

    public void setTransactionRegistry(TransactionRegistry registry) {
        try {
            Field field = org.apache.commons.dbcp.managed.BasicManagedDataSource.class.getDeclaredField("transactionRegistry");
            field.setAccessible(true);
            field.set((Object)this, registry);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }
}

