/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.management.console.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentURLFetcher {
    private static final Logger log = LoggerFactory.getLogger(ContentURLFetcher.class);
    private Set<String> protectedPaths = new HashSet();
    private String prefix;
    private String suffix;
    private final ServletContext context;

    public ContentURLFetcher(ServletContext context, String prefix, String suffix) {
        this.protectedPaths.add("/?WEB-INF/.*");
        this.protectedPaths.add(".*css");
        this.protectedPaths.add(".*gif");
        this.protectedPaths.add(".*ico");
        this.protectedPaths.add(".*jpeg");
        this.protectedPaths.add(".*jpg");
        this.protectedPaths.add(".*js");
        this.protectedPaths.add(".*png");
        this.prefix = "";
        this.suffix = "";
        this.context = context;
        this.prefix = prefix != null ? prefix : "";
        this.suffix = suffix != null ? suffix : "";
    }

    public URL getRequestedContentURL(String rawRequestPath) throws MalformedURLException {
        if (!this.isAllowed(rawRequestPath)) {
            if (log.isWarnEnabled()) {
                log.warn("An attempt to access protected content at " + rawRequestPath + " was disallowed.");
            }
            return null;
        }
        String localResourcePath = String.format("%s%s%s", this.prefix, rawRequestPath, this.suffix);
        URL resource = this.context.getResource(localResourcePath);
        if (resource == null && log.isDebugEnabled()) {
            log.debug("Content not found: " + localResourcePath);
        }
        return resource;
    }

    private boolean isAllowed(String resourcePath) {
        for (String protectedPath : this.protectedPaths) {
            if (!resourcePath.matches(protectedPath)) continue;
            return false;
        }
        return true;
    }
}

