/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.oxm.XMLField;

public class XPathFragment {
    public static final XPathFragment TEXT_FRAGMENT = new XPathFragment("text()");
    public static final String SELF_XPATH = ".";
    public static final XPathFragment SELF_FRAGMENT = new XPathFragment(".");
    public static final XPathFragment ANY_FRAGMENT = null;
    private XPathFragment nextFragment;
    private XMLField xmlField;
    private String xpath;
    protected boolean hasAttribute = false;
    private boolean hasText = false;
    private boolean hasNamespace = false;
    private boolean containsIndex = false;
    private int indexValue = -1;
    private boolean shouldExecuteSelectNodes = false;
    private String shortName;
    private byte[] shortNameBytes;
    private String prefix;
    private String localName;
    private String namespaceURI;
    protected boolean nameIsText = false;
    protected boolean isSelfFragment = false;
    private QName leafElementType;
    private boolean generatedPrefix = false;
    private XPathPredicate predicate;
    private boolean namespaceAware;
    private char namespaceSeparator;

    public XPathFragment() {
        this.setNamespaceAware(true);
        this.namespaceSeparator = (char)58;
    }

    public XPathFragment(String xpathString) {
        this(xpathString, ':', true);
    }

    public XPathFragment(String xpathString, char namespaceSeparator, boolean namespaceAware) {
        this.namespaceSeparator = namespaceSeparator;
        this.setNamespaceAware(namespaceAware);
        this.setXPath(xpathString);
    }

    public void setPredicate(XPathPredicate condition) {
        this.predicate = condition;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean isNamespaceAware) {
        this.namespaceAware = isNamespaceAware;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    public XPathPredicate getPredicate() {
        return this.predicate;
    }

    public XPathFragment getNextFragment() {
        return this.nextFragment;
    }

    public void setNextFragment(XPathFragment nextFragment) {
        this.nextFragment = nextFragment;
    }

    public void setXPath(String xpathString) {
        this.xpath = xpathString;
        this.shortName = xpathString;
        if (xpathString.length() > 0) {
            if (this.xpath.indexOf(91) != -1 && this.xpath.indexOf(93) == -1) {
                this.setShouldExecuteSelectNodes(true);
                return;
            }
            if (this.xpath.indexOf("::") != -1) {
                this.setShouldExecuteSelectNodes(true);
                return;
            }
            if (xpathString.charAt(0) == '@') {
                this.hasAttribute = true;
                this.shortName = xpathString.substring(1).intern();
                this.indexValue = this.hasIndex(xpathString);
                this.setupNamespaceInformation(this.shortName);
                return;
            }
            if (xpathString.charAt(0) == '/') {
                this.setShouldExecuteSelectNodes(true);
                this.shortName = xpathString.substring(xpathString.lastIndexOf(47) + 1).intern();
                this.indexValue = this.hasIndex(xpathString);
                this.setupNamespaceInformation(this.shortName);
                return;
            }
        }
        if (xpathString.equals("text()")) {
            this.nameIsText = true;
            this.shortName = xpathString.intern();
            return;
        }
        this.nameIsText = false;
        if (xpathString.equals(SELF_XPATH)) {
            this.isSelfFragment = true;
            this.shortName = xpathString.intern();
            return;
        }
        this.indexValue = this.hasIndex(xpathString);
        this.setupNamespaceInformation(this.shortName);
    }

    private void setupNamespaceInformation(String xpathString) {
        int nsindex = xpathString.indexOf(this.namespaceSeparator);
        if (nsindex != -1) {
            this.hasNamespace = true;
            this.localName = xpathString.substring(nsindex + 1).intern();
            this.prefix = xpathString.substring(0, nsindex).intern();
        } else {
            this.localName = xpathString.intern();
        }
    }

    public boolean isAttribute() {
        return this.hasAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.hasAttribute = isAttribute;
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.shortName = this.prefix != null && this.prefix.length() > 0 ? String.valueOf(this.prefix) + ':' + this.localName : this.localName;
        }
        return this.shortName;
    }

    public byte[] getShortNameBytes() {
        if (this.shortNameBytes == null) {
            try {
                this.shortNameBytes = this.getShortName().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return this.shortNameBytes;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.resetShortName();
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
        this.resetShortName();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = this.isSelfFragment || namespaceURI != null && namespaceURI.length() == 0 ? null : namespaceURI;
    }

    private int hasIndex(String xpathString) {
        int index = -1;
        int startindex = xpathString.lastIndexOf(91);
        if (startindex != -1 && xpathString.lastIndexOf(93) != -1) {
            StringTokenizer st = new StringTokenizer(xpathString, "[]");
            String element = st.nextToken();
            while (st.hasMoreTokens()) {
                String indexString = st.nextToken();
                try {
                    index = Integer.valueOf(indexString);
                    this.setContainsIndex(true);
                }
                catch (NumberFormatException numberFormatException) {
                    StringTokenizer st2 = new StringTokenizer(indexString, "=");
                    if (2 == st2.countTokens()) {
                        XPathFragment xPathFragment = new XPathFragment(st2.nextToken());
                        String value = st2.nextToken();
                        value = value.substring(1, value.length() - 1);
                        this.predicate = new XPathPredicate(xPathFragment, value);
                    } else {
                        this.setContainsIndex(true);
                    }
                    this.setShouldExecuteSelectNodes(true);
                }
            }
            this.shortName = element;
        } else {
            index = -1;
        }
        return index;
    }

    public int getIndexValue() {
        return this.indexValue;
    }

    public void setIndexValue(int indexValue) {
        this.indexValue = indexValue;
    }

    public String getXPath() {
        return this.xpath;
    }

    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    public boolean isSelfFragment() {
        return this.isSelfFragment;
    }

    public boolean nameIsText() {
        return this.nameIsText;
    }

    public void setHasText(boolean hasText) {
        this.hasText = hasText;
    }

    public boolean getHasText() {
        return this.hasText;
    }

    public void setContainsIndex(boolean containsIndex) {
        this.containsIndex = containsIndex;
    }

    public boolean containsIndex() {
        return this.containsIndex;
    }

    public void setShouldExecuteSelectNodes(boolean newShouldExecuteSelectNodes) {
        this.shouldExecuteSelectNodes = newShouldExecuteSelectNodes;
    }

    public boolean shouldExecuteSelectNodes() {
        return this.shouldExecuteSelectNodes;
    }

    public boolean equals(Object object) {
        XPathFragment xPathFragment;
        block19: {
            block18: {
                block16: {
                    block17: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        if (object == null) {
                                            return false;
                                        }
                                        if (this == object) {
                                            return true;
                                        }
                                        try {
                                            xPathFragment = (XPathFragment)object;
                                            if (!this.nameIsText || !xPathFragment.nameIsText) break block12;
                                            return true;
                                        }
                                        catch (ClassCastException classCastException) {
                                            return false;
                                        }
                                    }
                                    if (this.nameIsText == xPathFragment.nameIsText) break block13;
                                    return false;
                                }
                                if ((this.localName != null || xPathFragment.localName == null) && (this.localName == null || xPathFragment.localName != null)) break block14;
                                return false;
                            }
                            if (this.localName == null || this.localName.equals(xPathFragment.localName)) break block15;
                            return false;
                        }
                        if (!this.namespaceAware || !xPathFragment.isNamespaceAware()) break block16;
                        if ((this.namespaceURI != null || xPathFragment.namespaceURI == null) && (this.namespaceURI == null || xPathFragment.namespaceURI != null)) break block17;
                        return false;
                    }
                    if (this.namespaceURI == null || this.namespaceURI.equals(xPathFragment.namespaceURI)) break block16;
                    return false;
                }
                if (this.indexValue == xPathFragment.indexValue) break block18;
                return false;
            }
            if (this.predicate != null || xPathFragment.predicate == null) break block19;
            return false;
        }
        return this.predicate == null || this.predicate.equals(xPathFragment.predicate);
    }

    public int hashCode() {
        if (this.localName == null) {
            return 1;
        }
        return this.localName.hashCode();
    }

    public QName getLeafElementType() {
        return this.leafElementType;
    }

    public boolean hasLeafElementType() {
        return this.leafElementType != null;
    }

    public void setLeafElementType(QName type) {
        this.leafElementType = type;
    }

    public void setGeneratedPrefix(boolean isGenerated) {
        this.generatedPrefix = isGenerated;
    }

    public boolean isGeneratedPrefix() {
        return this.generatedPrefix;
    }

    public XMLField getXMLField() {
        return this.xmlField;
    }

    public void setXMLField(XMLField field) {
        this.xmlField = field;
    }

    private void resetShortName() {
        this.shortName = null;
        this.shortNameBytes = null;
    }
}

