/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.handler.PortletContentGenerator;
import org.springframework.web.portlet.mvc.Controller;
import org.springframework.web.portlet.util.PortletUtils;

public abstract class AbstractController
extends PortletContentGenerator
implements Controller {
    private boolean synchronizeOnSession = false;
    private boolean renderWhenMinimized = false;

    public final void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public final boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    public final void setRenderWhenMinimized(boolean renderWhenMinimized) {
        this.renderWhenMinimized = renderWhenMinimized;
    }

    public final boolean isRenderWhenMinimized() {
        return this.renderWhenMinimized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleActionRequest(ActionRequest request, ActionResponse response) throws Exception {
        PortletSession session;
        this.check((PortletRequest)request, (PortletResponse)response);
        if (this.synchronizeOnSession && (session = request.getPortletSession(false)) != null) {
            PortletSession portletSession = session;
            synchronized (portletSession) {
                this.handleActionRequestInternal(request, response);
                return;
            }
        }
        this.handleActionRequestInternal(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRenderRequest(RenderRequest request, RenderResponse response) throws Exception {
        PortletSession session;
        if (WindowState.MINIMIZED.equals((Object)request.getWindowState()) && !this.renderWhenMinimized) {
            return null;
        }
        this.checkAndPrepare((PortletRequest)request, (MimeResponse)response);
        if (this.synchronizeOnSession && (session = request.getPortletSession(false)) != null) {
            Object mutex;
            Object object = mutex = PortletUtils.getSessionMutex(session);
            synchronized (object) {
                return this.handleRenderRequestInternal(request, response);
            }
        }
        return this.handleRenderRequestInternal(request, response);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        throw new PortletException("[" + this.getClass().getName() + "] does not handle action requests");
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        throw new PortletException("[" + this.getClass().getName() + "] does not handle render requests");
    }
}

