/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl.thread;

import java.io.PrintWriter;
import java.lang.management.ThreadInfo;
import org.eclipse.virgo.medic.dump.impl.thread.ThreadInfoWriter;

final class Java5ThreadInfoWriter
implements ThreadInfoWriter {
    Java5ThreadInfoWriter() {
    }

    public void write(ThreadInfo threadInfo, PrintWriter writer) {
        StackTraceElement[] stackTraceElements;
        writer.print(String.format("\"%s\" Id=%s %s", new Object[]{threadInfo.getThreadName(), threadInfo.getThreadId(), threadInfo.getThreadState()}));
        if (threadInfo.getLockName() != null) {
            writer.print(String.format(" on %s", threadInfo.getLockName()));
            if (threadInfo.getLockOwnerName() != null) {
                writer.print(String.format(" owned by \"%s\" Id=%s", threadInfo.getLockOwnerName(), threadInfo.getLockOwnerId()));
            }
        }
        if (threadInfo.isInNative()) {
            writer.println(" (in native)");
        } else {
            writer.println();
        }
        StackTraceElement[] stackTraceElementArray = stackTraceElements = threadInfo.getStackTrace();
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            writer.println("    at " + stackTraceElement);
            ++n2;
        }
    }
}

