/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.internal.cm;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.osgi.compendium.internal.cm.CMUtils;
import org.springframework.osgi.compendium.internal.cm.UpdateCallback;
import org.springframework.osgi.compendium.internal.cm.UpdateStrategy;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.service.exporter.OsgiServiceRegistrationListener;
import org.springframework.osgi.service.exporter.support.AutoExport;
import org.springframework.osgi.service.exporter.support.ExportContextClassLoader;
import org.springframework.osgi.service.exporter.support.OsgiServiceFactoryBean;
import org.springframework.osgi.service.importer.support.internal.collection.DynamicCollection;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ManagedServiceFactoryFactoryBean
implements InitializingBean,
BeanClassLoaderAware,
BeanFactoryAware,
BundleContextAware,
DisposableBean,
FactoryBean {
    private static final Log log = LogFactory.getLog((Class)ManagedServiceFactoryFactoryBean.class);
    private final Object monitor = new Object();
    private String factoryPid;
    private BundleContext bundleContext;
    private AbstractBeanFactory beanFactory;
    private BeanDefinitionRegistry definitionRegistry;
    private BeanDefinition templateDefinition;
    private BeanFactory owningBeanFactory;
    private ServiceRegistration configurationWatcher;
    private UpdateCallback updateCallback;
    private final DynamicCollection serviceRegistrations = new DynamicCollection(8);
    private final Collection userReturnedCollection = Collections.unmodifiableCollection(this.serviceRegistrations);
    private final Map serviceExporters = CollectionFactory.createConcurrentMap((int)8);
    private OsgiServiceRegistrationListener[] listeners = new OsgiServiceRegistrationListener[0];
    private AutoExport autoExport = AutoExport.DISABLED;
    private ExportContextClassLoader ccl = ExportContextClassLoader.UNMANAGED;
    private Class[] interfaces;
    private ClassLoader classLoader;
    private UpdateStrategy updateStrategy;
    private String updateMethod;
    public Map initialInjectionProperties;
    private boolean destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            Assert.notNull((Object)this.factoryPid, (String)"factoryPid required");
            Assert.notNull((Object)this.bundleContext, (String)"bundleContext is required");
            Assert.notNull((Object)this.templateDefinition, (String)"templateDefinition is required");
            Assert.isTrue((!AutoExport.DISABLED.equals((Object)this.autoExport) || !ObjectUtils.isEmpty((Object[])this.interfaces) ? 1 : 0) != 0, (String)"No service interface(s) specified and auto-export discovery disabled; change at least one of these properties");
        }
        this.templateDefinition.setScope("singleton");
        this.createEmbeddedBeanFactory();
        this.updateCallback = CMUtils.createCallback(this.updateStrategy, this.updateMethod, (BeanFactory)this.beanFactory);
        this.registerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            this.destroyed = true;
            OsgiServiceUtils.unregisterService(this.configurationWatcher);
            this.configurationWatcher = null;
            this.destroyFactory();
        }
        object = this.serviceRegistrations;
        synchronized (object) {
            this.serviceRegistrations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmbeddedBeanFactory() {
        Object object = this.monitor;
        synchronized (object) {
            DefaultListableBeanFactory bf = new DefaultListableBeanFactory(this.owningBeanFactory);
            if (this.owningBeanFactory instanceof ConfigurableBeanFactory) {
                bf.copyConfigurationFrom((ConfigurableBeanFactory)this.owningBeanFactory);
            }
            bf.setBeanClassLoader(this.classLoader);
            bf.addBeanPostProcessor((BeanPostProcessor)new InitialInjectionProcessor());
            this.beanFactory = bf;
            this.definitionRegistry = bf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService() {
        Object object = this.monitor;
        synchronized (object) {
            Hashtable<String, String> props = new Hashtable<String, String>(2);
            ((Dictionary)props).put("service.pid", this.factoryPid);
            this.configurationWatcher = this.bundleContext.registerService(ManagedServiceFactory.class.getName(), (Object)new ConfigurationWatcher(), props);
        }
    }

    private void destroyFactory() {
        if (this.beanFactory != null) {
            this.beanFactory.destroySingletons();
            this.beanFactory = null;
            this.definitionRegistry = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdate(String pid, Map props) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (this.beanFactory.containsBean(pid)) {
                this.updateInstance(pid, props);
            } else {
                this.createInstance(pid, props);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInstance(String pid, Map props) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.definitionRegistry.registerBeanDefinition(pid, this.templateDefinition);
            this.initialInjectionProperties = props;
            Object bean = this.beanFactory.getBean(pid);
            this.registerService(pid, bean);
        }
    }

    private void registerService(String pid, Object bean) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        ((Dictionary)props).put("service.pid", pid);
        OsgiServiceFactoryBean exporter = this.createExporter(pid, bean);
        this.serviceExporters.put(pid, exporter);
        try {
            this.serviceRegistrations.add(exporter.getObject());
        }
        catch (Exception ex) {
            throw new BeanCreationException("Cannot publish bean for pid " + pid, (Throwable)ex);
        }
    }

    private OsgiServiceFactoryBean createExporter(String beanName, Object bean) {
        OsgiServiceFactoryBean exporter = new OsgiServiceFactoryBean();
        exporter.setAutoExport(this.autoExport);
        exporter.setBeanClassLoader(this.classLoader);
        exporter.setBeanName(beanName);
        exporter.setBundleContext(this.bundleContext);
        exporter.setContextClassLoader(this.ccl);
        exporter.setInterfaces(this.interfaces);
        exporter.setListeners(this.listeners);
        exporter.setTarget(bean);
        try {
            exporter.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new BeanCreationException("Cannot publish bean for pid " + beanName, (Throwable)ex);
        }
        return exporter;
    }

    private void updateInstance(String pid, Map props) {
        if (this.updateCallback != null) {
            Object instance = this.beanFactory.getBean(pid);
            this.updateCallback.update(instance, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInstance(String pid) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (this.definitionRegistry.containsBeanDefinition(pid)) {
                this.unregisterService(pid);
                this.definitionRegistry.removeBeanDefinition(pid);
            }
        }
    }

    private void unregisterService(String pid) {
        OsgiServiceFactoryBean exporterFactory = (OsgiServiceFactoryBean)this.serviceExporters.remove(pid);
        if (exporterFactory != null) {
            Object registration = null;
            try {
                registration = exporterFactory.getObject();
            }
            catch (Exception ex) {
                log.error((Object)("Could not retrieve registration for pid " + pid), (Throwable)ex);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Unpublishing bean for pid " + pid + " w/ registration " + registration));
            }
            this.serviceRegistrations.remove(registration);
            exporterFactory.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Object object = this.monitor;
        synchronized (object) {
            this.owningBeanFactory = beanFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundleContext(BundleContext bundleContext) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleContext = bundleContext;
        }
    }

    public Object getObject() throws Exception {
        return this.userReturnedCollection;
    }

    public Class getObjectType() {
        return Collection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setListeners(OsgiServiceRegistrationListener[] listeners) {
        if (listeners != null) {
            this.listeners = listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactoryPid(String factoryPid) {
        Object object = this.monitor;
        synchronized (object) {
            this.factoryPid = factoryPid;
        }
    }

    public void setTemplateDefinition(BeanDefinition[] templateDefinition) {
        this.templateDefinition = templateDefinition != null && templateDefinition.length > 0 ? templateDefinition[0] : null;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setAutoExport(AutoExport autoExport) {
        this.autoExport = autoExport;
    }

    public void setContextClassLoader(ExportContextClassLoader ccl) {
        this.ccl = ccl;
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public void setUpdateMethod(String updateMethod) {
        this.updateMethod = updateMethod;
    }

    private class InitialInjectionProcessor
    implements BeanPostProcessor {
        private InitialInjectionProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            CMUtils.applyMapOntoInstance(bean, ManagedServiceFactoryFactoryBean.this.initialInjectionProperties, ManagedServiceFactoryFactoryBean.this.beanFactory);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Applying initial injection for managed bean " + beanName));
            }
            return bean;
        }
    }

    private class ConfigurationWatcher
    implements ManagedServiceFactory {
        private ConfigurationWatcher() {
        }

        public void deleted(String pid) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Configuration [" + pid + "] has been deleted"));
            }
            ManagedServiceFactoryFactoryBean.this.destroyInstance(pid);
        }

        public String getName() {
            return "Spring DM managed-service-factory support";
        }

        public void updated(String pid, Dictionary props) throws ConfigurationException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Configuration [" + pid + "] has been updated with properties " + props));
            }
            ManagedServiceFactoryFactoryBean.this.createOrUpdate(pid, new MapBasedDictionary(props));
        }
    }
}

