/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.pipeline.stage;

import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.environment.InstallLog;
import org.eclipse.virgo.kernel.install.pipeline.stage.PipelineStage;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;

public abstract class AbstractPipelineStage
implements PipelineStage {
    @Override
    public final void process(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException, UnableToSatisfyBundleDependenciesException {
        InstallLog installLog = installEnvironment.getInstallLog();
        installLog.log(this, "process entry with installGraph '%s'", installGraph.toString());
        try {
            this.doProcessGraph(installGraph, installEnvironment);
        }
        catch (DeploymentException de) {
            installLog.log(this, "process exit with installGraph '%s', exception '%s' thrown", installGraph.toString(), de.toString());
            throw de;
        }
        catch (UnableToSatisfyBundleDependenciesException utsbde) {
            installLog.log(this, "process exit with installGraph '%s', exception '%s' thrown", installGraph.toString(), utsbde.toString());
            throw utsbde;
        }
        catch (RuntimeException re) {
            installLog.log(this, "process exit with installGraph '%s', exception '%s' thrown", installGraph.toString(), re.toString());
            throw re;
        }
        installLog.log(this, "process exit with installGraph '%s'", installGraph.toString());
    }

    protected void doProcessGraph(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException, UnableToSatisfyBundleDependenciesException {
        InstallArtifact value = (InstallArtifact)installGraph.getValue();
        this.doProcessNode(value, installEnvironment);
        for (GraphNode child : installGraph.getChildren()) {
            this.doProcessGraph((GraphNode<InstallArtifact>)child, installEnvironment);
        }
    }

    protected void doProcessNode(InstallArtifact installArtifact, InstallEnvironment installEnvironment) throws DeploymentException {
    }
}

