/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.wls.shaded.org.apache.xalan.xsltc.dom;

import com.oracle.wls.shaded.org.apache.xalan.xsltc.runtime.BasisLibrary;
import com.oracle.wls.shaded.org.apache.xml.dtm.DTMAxisIterator;
import com.oracle.wls.shaded.org.apache.xml.dtm.ref.DTMAxisIteratorBase;

public abstract class MultiValuedNodeHeapIterator
extends DTMAxisIteratorBase {
    private static final int InitSize = 8;
    private int _heapSize = 0;
    private int _size = 8;
    private HeapNode[] _heap = new HeapNode[8];
    private int _free = 0;
    private int _returnedLast;
    private int _cachedReturnedLast = -1;
    private int _cachedHeapSize;

    public DTMAxisIterator cloneIterator() {
        this._isRestartable = false;
        HeapNode[] heapCopy = new HeapNode[this._heap.length];
        try {
            MultiValuedNodeHeapIterator clone = (MultiValuedNodeHeapIterator)super.clone();
            int i = 0;
            while (i < this._free) {
                heapCopy[i] = this._heap[i].cloneHeapNode();
                ++i;
            }
            clone.setRestartable(false);
            clone._heap = heapCopy;
            return clone.reset();
        }
        catch (CloneNotSupportedException e) {
            BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", e.toString());
            return null;
        }
    }

    protected void addHeapNode(HeapNode node) {
        if (this._free == this._size) {
            HeapNode[] newArray = new HeapNode[this._size *= 2];
            System.arraycopy(this._heap, 0, newArray, 0, this._free);
            this._heap = newArray;
        }
        ++this._heapSize;
        this._heap[this._free++] = node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int next() {
        while (this._heapSize > 0) {
            int smallest = this._heap[0]._node;
            if (smallest == -1) {
                if (this._heapSize <= 1) return -1;
                HeapNode temp = this._heap[0];
                this._heap[0] = this._heap[--this._heapSize];
                this._heap[this._heapSize] = temp;
            } else if (smallest == this._returnedLast) {
                this._heap[0].step();
            } else {
                this._heap[0].step();
                this.heapify(0);
                this._returnedLast = smallest;
                return this.returnNode(this._returnedLast);
            }
            this.heapify(0);
        }
        return -1;
    }

    public DTMAxisIterator setStartNode(int node) {
        if (this._isRestartable) {
            this._startNode = node;
            int i = 0;
            while (i < this._free) {
                if (!this._heap[i]._isStartSet) {
                    this._heap[i].setStartNode(node);
                    this._heap[i].step();
                    this._heap[i]._isStartSet = true;
                }
                ++i;
            }
            this._heapSize = this._free;
            int i2 = this._heapSize / 2;
            while (i2 >= 0) {
                this.heapify(i2);
                --i2;
            }
            this._returnedLast = -1;
            return this.resetPosition();
        }
        return this;
    }

    protected void init() {
        int i = 0;
        while (i < this._free) {
            this._heap[i] = null;
            ++i;
        }
        this._heapSize = 0;
        this._free = 0;
    }

    private void heapify(int i) {
        while (true) {
            int r;
            int l;
            int smallest;
            int n = smallest = (l = (r = i + 1 << 1) - 1) < this._heapSize && this._heap[l].isLessThan(this._heap[i]) ? l : i;
            if (r < this._heapSize && this._heap[r].isLessThan(this._heap[smallest])) {
                smallest = r;
            }
            if (smallest == i) break;
            HeapNode temp = this._heap[smallest];
            this._heap[smallest] = this._heap[i];
            this._heap[i] = temp;
            i = smallest;
        }
    }

    public void setMark() {
        int i = 0;
        while (i < this._free) {
            this._heap[i].setMark();
            ++i;
        }
        this._cachedReturnedLast = this._returnedLast;
        this._cachedHeapSize = this._heapSize;
    }

    public void gotoMark() {
        int i = 0;
        while (i < this._free) {
            this._heap[i].gotoMark();
            ++i;
        }
        this._heapSize = this._cachedHeapSize;
        int i2 = this._heapSize / 2;
        while (i2 >= 0) {
            this.heapify(i2);
            --i2;
        }
        this._returnedLast = this._cachedReturnedLast;
    }

    public DTMAxisIterator reset() {
        int i = 0;
        while (i < this._free) {
            this._heap[i].reset();
            this._heap[i].step();
            ++i;
        }
        this._heapSize = this._free;
        int i2 = this._heapSize / 2;
        while (i2 >= 0) {
            this.heapify(i2);
            --i2;
        }
        this._returnedLast = -1;
        return this.resetPosition();
    }

    public abstract class HeapNode
    implements Cloneable {
        protected int _node;
        protected int _markedNode;
        protected boolean _isStartSet = false;

        public abstract int step();

        public HeapNode cloneHeapNode() {
            HeapNode clone;
            try {
                clone = (HeapNode)super.clone();
            }
            catch (CloneNotSupportedException e) {
                BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", e.toString());
                return null;
            }
            clone._node = this._node;
            clone._markedNode = this._node;
            return clone;
        }

        public void setMark() {
            this._markedNode = this._node;
        }

        public void gotoMark() {
            this._node = this._markedNode;
        }

        public abstract boolean isLessThan(HeapNode var1);

        public abstract HeapNode setStartNode(int var1);

        public abstract HeapNode reset();
    }
}

