/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import org.apache.openejb.resource.jdbc.cipher.PasswordCipher;
import org.apache.openejb.resource.jdbc.plugin.DataSourcePlugin;
import org.apache.xbean.finder.ResourceFinder;

public final class BasicDataSourceUtil {
    private BasicDataSourceUtil() {
    }

    public static DataSourcePlugin getDataSourcePlugin(String jdbcUrl) throws SQLException {
        String vendor = BasicDataSourceUtil.getJdbcName(jdbcUrl);
        if (vendor == null) {
            return null;
        }
        String pluginClassName = null;
        try {
            ResourceFinder finder = new ResourceFinder("META-INF");
            Map plugins = finder.mapAvailableStrings(DataSourcePlugin.class.getName());
            pluginClassName = (String)plugins.get(vendor);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (pluginClassName == null || pluginClassName.length() <= 0) {
            return null;
        }
        try {
            Class<?> pluginClass = Class.forName(pluginClassName);
            return (DataSourcePlugin)pluginClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Unable to load data source helper class '" + pluginClassName + "' for database '" + vendor + "'");
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Unable to create data source helper class '" + pluginClassName + "' for database '" + vendor + "'").initCause(e);
        }
    }

    public static String getJdbcName(String jdbcUrl) {
        if (jdbcUrl == null) {
            return null;
        }
        if (!jdbcUrl.startsWith("jdbc:")) {
            return null;
        }
        int index = (jdbcUrl = jdbcUrl.substring("jdbc:".length())).indexOf(58);
        if (index >= 0) {
            jdbcUrl = jdbcUrl.substring(0, index);
        }
        return jdbcUrl;
    }

    public static PasswordCipher getPasswordCipher(String passwordCipherClass) throws SQLException {
        PasswordCipher cipher;
        Map impls;
        ResourceFinder finder = new ResourceFinder("META-INF/");
        try {
            impls = finder.mapAllImplementations(PasswordCipher.class);
        }
        catch (Throwable t) {
            String message = "Password cipher '" + passwordCipherClass + "' not found in META-INF/org.apache.openejb.resource.jdbc.cipher.PasswordCipher.";
            throw new SQLException(message, t);
        }
        Class<PasswordCipher> pwdCipher = (Class<PasswordCipher>)impls.get(passwordCipherClass);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        URL url = tccl.getResource("META-INF/org.apache.openejb.resource.jdbc.cipher.PasswordCipher/" + passwordCipherClass);
        if (url != null) {
            try {
                String clazz = new BufferedReader(new InputStreamReader(url.openStream())).readLine().trim();
                pwdCipher = tccl.loadClass(clazz).asSubclass(PasswordCipher.class);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == pwdCipher) {
            try {
                try {
                    pwdCipher = Class.forName(passwordCipherClass).asSubclass(PasswordCipher.class);
                }
                catch (ClassNotFoundException cnfe) {
                    pwdCipher = tccl.loadClass(passwordCipherClass).asSubclass(PasswordCipher.class);
                }
            }
            catch (Throwable t) {
                String message = "Cannot load password cipher class '" + passwordCipherClass + "'";
                throw new SQLException(message, t);
            }
        }
        try {
            cipher = (PasswordCipher)pwdCipher.newInstance();
        }
        catch (Throwable t) {
            String message = "Cannot create password cipher instance";
            throw new SQLException(message, t);
        }
        return cipher;
    }
}

