/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Strings;

public class IntraVmJndiReference
extends Reference {
    private String jndiName;

    public IntraVmJndiReference(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Object getObject() throws NamingException {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        try {
            return containerSystem.getJNDIContext().lookup(this.jndiName);
        }
        catch (NameNotFoundException e) {
            return containerSystem.getJNDIContext().lookup("java:module/" + Strings.lastPart(this.getClassName(), '.'));
        }
        catch (NamingException e) {
            throw (NamingException)new NamingException("could not look up " + this.jndiName).initCause(e);
        }
    }

    public String toString() {
        return "IntraVmJndiReference{jndiName='" + this.jndiName + '\'' + '}';
    }
}

