/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.config.internal.StandardConfigurationExporter;
import org.eclipse.virgo.nano.core.ConfigurationExporter;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.util.common.IterableEnumeration;
import org.eclipse.virgo.util.common.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigurationPublisher {
    private final Logger LOGGER;
    private final ConfigurationAdmin configAdmin;
    private final PropertiesSource[] sources;
    private static final String KERNEL_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel";
    private static final String USER_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel.userregion";

    ConfigurationPublisher(ConfigurationAdmin configAdmin, PropertiesSource ... sources) {
        try {
            this.LOGGER = LoggerFactory.getLogger(this.getClass());
            this.configAdmin = configAdmin;
            this.sources = sources == null ? new PropertiesSource[]{} : sources;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void publishConfigurations() throws IOException {
        try {
            PropertiesSource[] propertiesSourceArray = this.sources;
            int n = this.sources.length;
            int n2 = 0;
            while (n2 < n) {
                PropertiesSource source = propertiesSourceArray[n2];
                Map<String, Properties> configurationProperties = source.getConfigurationProperties();
                if (configurationProperties != null) {
                    for (Map.Entry<String, Properties> entry : configurationProperties.entrySet()) {
                        this.populateConfigurationWithProperties(entry.getKey(), entry.getValue());
                    }
                }
                ++n2;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void registerConfigurationExporterService(@NonNull BundleContext context) throws IOException {
        BundleContext bundleContext = context;
        try {
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8(bundleContext);
            ConfigurationExporter configurationExporter = this.createConfigurationExporterService();
            context.registerService(ConfigurationExporter.class, (Object)configurationExporter, null);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ConfigurationExporter createConfigurationExporterService() throws IOException {
        try {
            Configuration kernelregionConfiguration = this.configAdmin.getConfiguration(KERNEL_REGION_CONFIGURATION_PID);
            Configuration userregionConfiguration = this.configAdmin.getConfiguration(USER_REGION_CONFIGURATION_PID);
            StandardConfigurationExporter configurationExporter = new StandardConfigurationExporter(userregionConfiguration, kernelregionConfiguration);
            return configurationExporter;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void populateConfigurationWithProperties(@NonNull String pid, @NonNull Properties properties) throws IOException {
        Properties properties2 = properties;
        String string = pid;
        try {
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8(string);
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82(properties2);
            Configuration config = this.getConfiguration(pid, properties);
            Hashtable configProperties = config.getProperties();
            if (configProperties == null) {
                configProperties = new Hashtable();
            }
            for (Object key : new IterableEnumeration(properties.keys())) {
                Object value = properties.get(key);
                ((Dictionary)configProperties).put(key, value);
            }
            try {
                config.update(configProperties);
            }
            catch (RuntimeException e) {
                this.LOGGER.error(String.format("Failed to update configuration for pid '%s'", pid), (Throwable)e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Configuration getConfiguration(String pid, Properties properties) throws IOException {
        try {
            Configuration result = null;
            String factoryPid = properties.getProperty("service.factoryPid");
            result = StringUtils.hasText((String)factoryPid) ? this.configAdmin.createFactoryConfiguration(factoryPid, null) : this.configAdmin.getConfiguration(pid, null);
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

