/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.osgicommand;

import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.osgi.framework.ServiceUtils;
import org.eclipse.virgo.shell.CommandExecutor;
import org.eclipse.virgo.shell.osgicommand.internal.GogoClassLoadingCommand;
import org.eclipse.virgo.shell.osgicommand.internal.GogoKernelShellCommand;
import org.eclipse.virgo.shell.osgicommand.management.ClassLoadingSupport;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final String KERNEL_SHELL_COMMAND = "vsh";
    private static final String[] KERNEL_SHELL_SUBCOMMANDS = new String[]{"bundle", "config", "install", "packages", "par", "plan", "service", "shutdown"};
    private static final String[] CLASS_LOADING_SUBCOMMANDS = new String[]{"clhas", "clload", "clexport"};
    private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName classLoadingObjectName = new ObjectName("org.eclipse.virgo.kernel:type=Classloading");
    private ServiceRegistration<GogoClassLoadingCommand> classLoadingCommandRegistration;

    public void start(BundleContext context) throws Exception {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", KERNEL_SHELL_COMMAND);
        ((Dictionary)properties).put("osgi.command.function", CLASS_LOADING_SUBCOMMANDS);
        this.classLoadingCommandRegistration = context.registerService(GogoClassLoadingCommand.class, (Object)new GogoClassLoadingCommand(context), properties);
        this.server.registerMBean(new ClassLoadingSupport(context), this.classLoadingObjectName);
        PostStartInitialisationRunnable runnable = new PostStartInitialisationRunnable(context, this.registrationTracker);
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.classLoadingCommandRegistration != null) {
            this.classLoadingCommandRegistration.unregister();
            this.classLoadingCommandRegistration = null;
        }
        this.registrationTracker.unregisterAll();
        this.server.unregisterMBean(this.classLoadingObjectName);
    }

    private static final class PostStartInitialisationRunnable
    implements Runnable {
        private final BundleContext context;
        private final ServiceRegistrationTracker registrationTracker;

        public PostStartInitialisationRunnable(BundleContext context, ServiceRegistrationTracker registrationTracker) {
            this.context = context;
            this.registrationTracker = registrationTracker;
        }

        @Override
        public void run() {
            CommandExecutor commandExecutor = null;
            try {
                commandExecutor = (CommandExecutor)ServiceUtils.getPotentiallyDelayedService((BundleContext)this.context, CommandExecutor.class);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException interruptedException) {}
            if (commandExecutor == null) {
                return;
            }
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("osgi.command.scope", Activator.KERNEL_SHELL_COMMAND);
            ((Dictionary)properties).put("osgi.command.function", KERNEL_SHELL_SUBCOMMANDS);
            this.registrationTracker.track(this.context.registerService(GogoKernelShellCommand.class, (Object)new GogoKernelShellCommand(commandExecutor), properties));
        }
    }
}

