/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.util.Arrays;
import java.util.List;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter;
import org.eclipse.virgo.shell.internal.util.QuasiServiceUtil;
import org.eclipse.virgo.shell.internal.util.ServiceHolder;

@Command(value="service")
public final class ServiceCommands {
    private final ServiceCommandFormatter formatter;
    private QuasiServiceUtil quasiServiceUtil;

    public ServiceCommands(QuasiServiceUtil quasiServiceUtil) {
        this.quasiServiceUtil = quasiServiceUtil;
        this.formatter = new ServiceCommandFormatter();
    }

    @Command(value="list")
    public List<String> list() {
        return this.formatter.formatList(this.quasiServiceUtil.getAllServices());
    }

    @Command(value="examine")
    public List<String> examine(long serviceId) {
        ServiceHolder service = this.quasiServiceUtil.getService(serviceId);
        if (service == null) {
            return Arrays.asList(String.format("No service with id '%s' was found", serviceId));
        }
        return this.formatter.formatExamine(service);
    }
}

