/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.management;

import java.net.URI;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.DuplicateArtifactException;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.MutableRepository;
import org.eclipse.virgo.repository.internal.management.AbstractRepositoryInfo;
import org.eclipse.virgo.repository.management.ArtifactDescriptorSummary;
import org.eclipse.virgo.repository.management.ExternalStorageRepositoryInfo;
import org.eclipse.virgo.util.jmx.ExceptionCleaner;
import org.osgi.framework.Version;

public class StandardExternalStorageRepositoryInfo
extends AbstractRepositoryInfo
implements ExternalStorageRepositoryInfo {
    private static final String TYPE = "external";
    private final MutableRepository repository;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public StandardExternalStorageRepositoryInfo(String name, ArtifactDescriptorDepository depository, MutableRepository repository) {
        super(name, depository);
        this.repository = repository;
    }

    @Override
    public String getType() {
        try {
            return TYPE;
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    @Override
    public ArtifactDescriptorSummary publish(String artifactUri) {
        try {
            URI uri = URI.create(artifactUri);
            try {
                ArtifactDescriptor published = this.repository.publish(uri);
                ArtifactDescriptorSummary summary = null;
                if (published != null) {
                    summary = new ArtifactDescriptorSummary(published.getType(), published.getName(), published.getVersion().toString());
                }
                return summary;
            }
            catch (DuplicateArtifactException dae) {
                throw new IllegalArgumentException("The artifact '" + artifactUri + "' cannot be published: it is a duplicate of existing artifact '" + dae.getOriginal().getUri() + "'");
            }
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    @Override
    public boolean retract(String type, String name, String version) {
        try {
            return this.repository.retract(type, name, new Version(version));
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    @Override
    public Set<String> getArtifactLocations(String filename) {
        try {
            return this.repository.getArtifactLocations(filename);
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.management.StandardExternalStorageRepositoryInfo");
    }
}

