/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.naming.Constants;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.http.FastHttpDateFormat;

public class DirContextURLConnection
extends URLConnection {
    private static final UDecoder URL_DECODER = new UDecoder();
    private static final UEncoder URL_ENCODER = new UEncoder();
    protected DirContext context;
    protected Resource resource;
    protected DirContext collection;
    protected Object object;
    protected Attributes attributes;
    protected long date;
    protected Permission permission;
    private String path = null;

    public DirContextURLConnection(DirContext context, URL url) {
        super(url);
        if (context == null) {
            throw new IllegalArgumentException("Directory context can't be null");
        }
        if (Constants.IS_SECURITY_ENABLED) {
            this.permission = new JndiPermission(url.toString());
        }
        this.context = context;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            try {
                this.date = System.currentTimeMillis();
                this.path = URL_DECODER.convert(this.getURL().getFile(), false);
                if (this.context instanceof ProxyDirContext) {
                    ProxyDirContext proxyDirContext = (ProxyDirContext)this.context;
                    String hostName = proxyDirContext.getHostName();
                    String contextPath = proxyDirContext.getContextPath();
                    if (hostName != null) {
                        if (!this.path.startsWith("/" + hostName + "/")) {
                            return;
                        }
                        this.path = this.path.substring(hostName.length() + 1);
                    }
                    if (contextPath != null) {
                        if (!this.path.startsWith(contextPath + "/")) {
                            return;
                        }
                        this.path = this.path.substring(contextPath.length());
                    }
                }
                this.object = this.context.lookup(this.path);
                this.attributes = this.context.getAttributes(this.path);
                if (this.object instanceof Resource) {
                    this.resource = (Resource)this.object;
                }
                if (this.object instanceof DirContext) {
                    this.collection = (DirContext)this.object;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.connected = true;
        }
    }

    @Override
    public int getContentLength() {
        return this.getHeaderFieldInt("getcontentlength", -1);
    }

    @Override
    public String getContentType() {
        return this.getHeaderField("getcontenttype");
    }

    @Override
    public long getDate() {
        return this.date;
    }

    @Override
    public long getLastModified() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return 0L;
        }
        Attribute lastModified = this.attributes.get("getlastmodified");
        if (lastModified != null) {
            try {
                Date lmDate = (Date)lastModified.get();
                return lmDate.getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    protected String getHeaderValueAsString(Object headerValue) {
        if (headerValue == null) {
            return null;
        }
        if (headerValue instanceof Date) {
            return FastHttpDateFormat.formatDate((long)((Date)headerValue).getTime(), null);
        }
        return headerValue.toString();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        HashMap headerFields = new HashMap(this.attributes.size());
        NamingEnumeration<String> attributeEnum = this.attributes.getIDs();
        try {
            while (attributeEnum.hasMore()) {
                String attributeID = attributeEnum.next();
                Attribute attribute = this.attributes.get(attributeID);
                if (attribute == null) continue;
                ArrayList<String> attributeValueList = new ArrayList<String>(attribute.size());
                NamingEnumeration<?> attributeValues = attribute.getAll();
                while (attributeValues.hasMore()) {
                    Object attrValue = attributeValues.next();
                    attributeValueList.add(this.getHeaderValueAsString(attrValue));
                }
                attributeValueList.trimToSize();
                headerFields.put(attributeID, Collections.unmodifiableList(attributeValueList));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return Collections.unmodifiableMap(headerFields);
    }

    @Override
    public String getHeaderField(String name) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.attributes == null) {
            return null;
        }
        NamingEnumeration<String> attributeEnum = this.attributes.getIDs();
        try {
            while (attributeEnum.hasMore()) {
                String attributeID = attributeEnum.next();
                if (!attributeID.equalsIgnoreCase(name)) continue;
                Attribute attribute = this.attributes.get(attributeID);
                if (attribute == null) {
                    return null;
                }
                Object attrValue = attribute.get(attribute.size() - 1);
                return this.getHeaderValueAsString(attrValue);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource != null) {
            return this.getInputStream();
        }
        if (this.collection != null) {
            return this.collection;
        }
        if (this.object != null) {
            return this.object;
        }
        throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
    }

    public Object getContent(Class[] classes) throws IOException {
        Object obj = this.getContent();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].isInstance(obj)) continue;
            return obj;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource == null) {
            throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
        }
        try {
            this.resource = (Resource)this.context.lookup(this.path);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return this.resource.streamContent();
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    public Enumeration<String> list() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource == null && this.collection == null) {
            throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
        }
        Vector<String> result = new Vector<String>();
        if (this.collection != null) {
            try {
                NamingEnumeration<NameClassPair> enumeration = this.collection.list("/");
                while (enumeration.hasMoreElements()) {
                    NameClassPair ncp = (NameClassPair)enumeration.nextElement();
                    String s = ncp.getName();
                    result.addElement(URL_ENCODER.encodeURL(s, 0, s.length()).toString());
                }
            }
            catch (NamingException e) {
                throw new FileNotFoundException(this.getURL() == null ? "null" : this.getURL().toString());
            }
        }
        return result.elements();
    }

    static {
        URL_ENCODER.addSafeCharacter('/');
    }
}

