/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;

public class TransactionBranchInfoImpl
implements TransactionBranchInfo {
    private final Xid branchXid;
    private final String resourceName;

    public TransactionBranchInfoImpl(Xid branchXid, String resourceName) {
        if (resourceName == null) {
            throw new NullPointerException("resourceName");
        }
        if (branchXid == null) {
            throw new NullPointerException("branchXid");
        }
        this.branchXid = branchXid;
        this.resourceName = resourceName;
    }

    public Xid getBranchXid() {
        return this.branchXid;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[Transaction branch:\n");
        b.append(" name:").append(this.resourceName);
        b.append("\n branchId: ");
        for (byte i : this.branchXid.getBranchQualifier()) {
            b.append(Integer.toHexString(i));
        }
        b.append("\n]\n");
        return b.toString();
    }
}

