/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.eventlog.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class ResourceBundleUtils {
    private static final String PROPERTIES_SUFFIX = ".properties";

    ResourceBundleUtils() {
    }

    static List<String> generateCandidatePropertiesFileNames(String baseName, Locale locale) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        candidateNames.addAll(ResourceBundleUtils.generateCandidatePropertiesFileNames(baseName, locale.getLanguage(), locale.getCountry(), locale.getVariant()));
        Locale defaultLocale = Locale.getDefault();
        if (!defaultLocale.equals(locale)) {
            candidateNames.addAll(ResourceBundleUtils.generateCandidatePropertiesFileNames(baseName, defaultLocale.getLanguage(), defaultLocale.getCountry(), defaultLocale.getVariant()));
        }
        candidateNames.add(String.valueOf(baseName) + PROPERTIES_SUFFIX);
        return candidateNames;
    }

    private static List<String> generateCandidatePropertiesFileNames(String baseName, String language, String country, String variant) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        if (ResourceBundleUtils.hasText(language)) {
            if (ResourceBundleUtils.hasText(country)) {
                if (ResourceBundleUtils.hasText(variant)) {
                    candidateNames.add(String.valueOf(baseName) + "_" + language + "_" + country + "_" + variant + PROPERTIES_SUFFIX);
                }
                candidateNames.add(String.valueOf(baseName) + "_" + language + "_" + country + PROPERTIES_SUFFIX);
            }
            candidateNames.add(String.valueOf(baseName) + "_" + language + PROPERTIES_SUFFIX);
        }
        return candidateNames;
    }

    private static boolean hasText(String string) {
        return string != null && string.length() > 0;
    }
}

