/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.plus.annotation.RunAs;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class RunAsAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(RunAsAnnotationHandler.class);
    protected WebAppContext _context;

    public RunAsAnnotationHandler(WebAppContext wac) {
        super(false);
        this._context = wac;
    }

    @Override
    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        javax.annotation.security.RunAs runAs = clazz.getAnnotation(javax.annotation.security.RunAs.class);
        if (runAs != null) {
            String role = runAs.value();
            if (role != null) {
                MetaData metaData;
                Descriptor d;
                ServletHolder holder = this.getServletHolderForClass(clazz);
                if (holder != null && (d = (metaData = this._context.getMetaData()).getOriginDescriptor(holder.getName() + ".servlet.run-as")) == null) {
                    metaData.setOrigin(holder.getName() + ".servlet.run-as");
                    RunAs ra = new RunAs();
                    ra.setTargetClassName(clazz.getCanonicalName());
                    ra.setRoleName(role);
                    RunAsCollection raCollection = (RunAsCollection)this._context.getAttribute("org.eclipse.jetty.runAsCollection");
                    if (raCollection == null) {
                        raCollection = new RunAsCollection();
                        this._context.setAttribute("org.eclipse.jetty.runAsCollection", (Object)raCollection);
                    }
                    raCollection.add(ra);
                }
            } else {
                LOG.warn("Bad value for @RunAs annotation on class " + clazz.getName(), new Object[0]);
            }
        }
    }

    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        LOG.warn("@RunAs annotation not applicable for fields: " + className + "." + fieldName, new Object[0]);
    }

    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        LOG.warn("@RunAs annotation ignored on method: " + className + "." + methodName + " " + signature, new Object[0]);
    }

    private ServletHolder getServletHolderForClass(Class clazz) {
        ServletHolder holder = null;
        ServletHolder[] holders = this._context.getServletHandler().getServlets();
        if (holders != null) {
            for (ServletHolder h : holders) {
                if (!h.getClassName().equals(clazz.getName())) continue;
                holder = h;
            }
        }
        return holder;
    }
}

