/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import org.eclipse.virgo.util.osgi.VersionRange;
import org.eclipse.virgo.util.osgi.manifest.RequiredBundle;
import org.eclipse.virgo.util.osgi.manifest.Resolution;
import org.eclipse.virgo.util.osgi.manifest.internal.BaseCompoundHeaderEntry;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;

public class StandardRequiredBundle
extends BaseCompoundHeaderEntry
implements RequiredBundle {
    StandardRequiredBundle(HeaderParser parser, String name) {
        super(parser, name);
    }

    public String getBundleSymbolicName() {
        return this.name;
    }

    public Resolution getResolution() {
        String value = this.getDirectives().get("resolution");
        if ("optional".equals(value)) {
            return Resolution.OPTIONAL;
        }
        return Resolution.MANDATORY;
    }

    public RequiredBundle.Visibility getVisibility() {
        String value = this.getDirectives().get("visibility");
        if ("reexport".equals(value)) {
            return RequiredBundle.Visibility.REEXPORT;
        }
        return RequiredBundle.Visibility.PRIVATE;
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        if (bundleSymbolicName == null) {
            throw new IllegalArgumentException("bundleSymbolicName must not be null");
        }
        this.name = bundleSymbolicName;
    }

    public void setResolution(Resolution resolution) {
        if (resolution == null) {
            this.getDirectives().remove("resolution");
        } else {
            switch (resolution) {
                case OPTIONAL: {
                    this.getDirectives().put("resolution", "optional");
                    break;
                }
                default: {
                    this.getDirectives().remove("resolution");
                }
            }
        }
    }

    public void setVisibility(RequiredBundle.Visibility visibility) {
        if (visibility == null) {
            this.getDirectives().remove("visibility");
        } else {
            switch (visibility) {
                case REEXPORT: {
                    this.getDirectives().put("visibility", "reexport");
                    break;
                }
                default: {
                    this.getDirectives().remove("visibility");
                }
            }
        }
    }

    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        return parser.parseRequireBundleHeader(parseString).get(0);
    }

    public VersionRange getBundleVersion() {
        return new VersionRange(this.getAttributes().get("bundle-version"));
    }

    public void setBundleVersion(VersionRange versionRange) {
        if (versionRange == null) {
            this.getAttributes().remove("bundle-version");
        } else {
            this.getAttributes().put("bundle-version", versionRange.toParseString());
        }
    }
}

