/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.bundle;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.ArtifactState;
import org.eclipse.virgo.kernel.model.internal.AbstractArtifact;
import org.eclipse.virgo.kernel.osgi.framework.PackageAdminUtil;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleArtifact
extends AbstractArtifact {
    static final String TYPE = "bundle";
    private final Logger logger;
    private final PackageAdminUtil packageAdminUtil;
    private final Bundle bundle;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public BundleArtifact(@NonNull BundleContext bundleContext, @NonNull PackageAdminUtil packageAdminUtil, @NonNull Bundle bundle) {
        Bundle bundle2 = bundle;
        PackageAdminUtil packageAdminUtil2 = packageAdminUtil;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)packageAdminUtil2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)bundle2);
        super(bundleContext, TYPE, bundle.getSymbolicName(), bundle.getVersion());
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.packageAdminUtil = packageAdminUtil;
            this.bundle = bundle;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public ArtifactState getState() {
        try {
            return this.mapBundleState(this.bundle.getState());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public boolean refresh() {
        try {
            boolean bl;
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                try {
                    this.bundle.update();
                    this.packageAdminUtil.synchronouslyRefreshPackages(new Bundle[]{this.bundle});
                    bl = true;
                }
                catch (BundleException e) {
                    this.logger.error("Unable to update bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                    throw new RuntimeException(String.format("Unable to update bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return bl;
        }
        catch (Throwable throwable) {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public void start() {
        try {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                try {
                    this.bundle.start();
                }
                catch (BundleException e) {
                    this.logger.error("Unable to start bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                    throw new RuntimeException(String.format("Unable to start bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public void stop() {
        try {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            try {
                try {
                    this.bundle.stop();
                }
                catch (BundleException e) {
                    this.logger.error("Unable to stop bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                    throw new RuntimeException(String.format("Unable to stop bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public void uninstall() {
        try {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            try {
                try {
                    this.bundle.uninstall();
                }
                catch (BundleException e) {
                    this.logger.error("Unable to uninstall bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                    throw new RuntimeException(String.format("Unable to uninstall bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private ArtifactState mapBundleState(int state) {
        try {
            ArtifactState artifactState;
            block10: {
                BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                try {
                    if (1 == state) {
                        artifactState = ArtifactState.UNINSTALLED;
                        break block10;
                    }
                    if (2 == state) {
                        artifactState = ArtifactState.INSTALLED;
                        break block10;
                    }
                    if (4 == state) {
                        artifactState = ArtifactState.RESOLVED;
                        break block10;
                    }
                    if (8 == state) {
                        artifactState = ArtifactState.STARTING;
                        break block10;
                    }
                    if (16 == state) {
                        artifactState = ArtifactState.STOPPING;
                        break block10;
                    }
                    if (32 == state) {
                        artifactState = ArtifactState.ACTIVE;
                        break block10;
                    }
                    throw new IllegalArgumentException(String.format("Unknown bundle state '%d'", state));
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
            }
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return artifactState;
        }
        catch (Throwable throwable) {
            BundleArtifact.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("BundleArtifact.java", Class.forName("org.eclipse.virgo.kernel.model.internal.bundle.BundleArtifact"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.model.internal.bundle.BundleArtifact", "", "", "", "boolean"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.model.internal.bundle.BundleArtifact", "", "", "", "void"), 78);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.model.internal.bundle.BundleArtifact", "", "", "", "void"), 91);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uninstall", "org.eclipse.virgo.kernel.model.internal.bundle.BundleArtifact", "", "", "", "void"), 104);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "mapBundleState", "org.eclipse.virgo.kernel.model.internal.bundle.BundleArtifact", "int:", "state:", "", "org.eclipse.virgo.kernel.model.ArtifactState"), 113);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.bundle.BundleArtifact");
    }
}

