/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleFragment
extends AbstractBundle {
    protected BundleHost[] hosts = null;

    public BundleFragment(BundleData bundledata, Framework framework) throws BundleException {
        super(bundledata, framework);
    }

    protected void load() {
        SecurityManager sm;
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.load called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.framework.isActive() && (sm = System.getSecurityManager()) != null && this.framework.securityAdmin != null) {
            this.domain = this.framework.securityAdmin.createProtectionDomain(this);
        }
    }

    protected boolean reload(AbstractBundle newBundle) {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.hosts != null && this.state == 4) {
                this.framework.packageAdmin.addRemovalPending(this.bundledata);
                exporting = true;
                this.hosts = null;
                this.state = 2;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        if (this.framework.isActive() && System.getSecurityManager() != null && this.framework.securityAdmin != null) {
            this.domain = this.framework.securityAdmin.createProtectionDomain(this);
        }
        return exporting;
    }

    protected void refresh() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.refresh called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            this.hosts = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive() && this.hosts != null) {
            if (this.state == 4) {
                this.framework.packageAdmin.addRemovalPending(this.bundledata);
                exporting = true;
                this.hosts = null;
                this.state = 2;
            }
            this.domain = null;
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            try {
                this.framework.checkAdminPermission(this, "class");
            }
            catch (SecurityException e) {
                throw new ClassNotFoundException(name, e);
            }
            this.checkValid();
        }
        throw new ClassNotFoundException(NLS.bind(Msg.BUNDLE_FRAGMENT_CNFE, name));
    }

    public URL getResource(String name) {
        this.checkValid();
        return null;
    }

    public Enumeration getResources(String name) {
        this.checkValid();
        return null;
    }

    protected void startWorker(int options) throws BundleException {
        throw new BundleException(NLS.bind(Msg.BUNDLE_FRAGMENT_START, this), 2);
    }

    protected void stopWorker(int options) throws BundleException {
        throw new BundleException(NLS.bind(Msg.BUNDLE_FRAGMENT_STOP, this), 2);
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        return null;
    }

    synchronized BundleHost[] getHosts() {
        return this.hosts;
    }

    protected boolean isFragment() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean addHost(BundleHost host) {
        if (host == null) {
            return false;
        }
        try {
            host.attachFragment(this);
        }
        catch (BundleException be) {
            this.framework.publishFrameworkEvent(2, host, be);
            return false;
        }
        BundleFragment bundleFragment = this;
        synchronized (bundleFragment) {
            if (this.hosts == null) {
                this.hosts = new BundleHost[]{host};
                return true;
            }
            int i = 0;
            while (true) {
                if (i >= this.hosts.length) {
                    BundleHost[] newHosts = new BundleHost[this.hosts.length + 1];
                    System.arraycopy(this.hosts, 0, newHosts, 0, this.hosts.length);
                    newHosts[newHosts.length - 1] = host;
                    this.hosts = newHosts;
                    return true;
                }
                if (host == this.hosts[i]) {
                    return true;
                }
                ++i;
            }
        }
    }

    protected BundleLoader getBundleLoader() {
        return null;
    }

    protected BundleContextImpl getContext() {
        return null;
    }
}

