/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import org.apache.felix.eventadmin.impl.handler.TopicHandlerFilters;
import org.apache.felix.eventadmin.impl.util.CacheMap;

public class CacheTopicHandlerFilters
implements TopicHandlerFilters {
    private final CacheMap m_cache;
    private final char[] m_keyChars = "event.topics".toCharArray();
    private final char[] m_filterStart;

    public CacheTopicHandlerFilters(CacheMap cache, boolean requireTopic) {
        if (null == cache) {
            throw new NullPointerException("Cache may not be null");
        }
        this.m_cache = cache;
        this.m_filterStart = ("(|" + (requireTopic ? "" : "(!(" + new String(this.m_keyChars) + "=*))") + "(" + new String(this.m_keyChars) + "=\\*)(" + new String(this.m_keyChars) + "=").toCharArray();
    }

    public String createFilterForTopic(String topic) {
        String result = (String)this.m_cache.get(topic);
        if (null == result) {
            char[] topicChars = topic.toCharArray();
            StringBuffer filter = new StringBuffer(topicChars.length * topicChars.length);
            filter.append(this.m_filterStart);
            for (int i = 0; i < topicChars.length; ++i) {
                if ('/' == topicChars[i]) {
                    filter.append('/').append('\\').append('*').append(')');
                    filter.append('(').append(this.m_keyChars).append('=').append(topicChars, 0, i + 1);
                    continue;
                }
                filter.append(topicChars[i]);
            }
            filter.append(')').append(')');
            result = filter.toString();
            this.m_cache.add(topic, result);
        }
        return result;
    }
}

