/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Random;

public final class NetUtils {
    private static final int MIN_SAFE_PORT = 1024;
    private static final int MAX_PORT = 65535;
    private static final Random random = new Random();

    /*
     * Loose catch block
     */
    public static boolean isPortAvailable(int port) {
        ServerSocket socket;
        try {
            socket = new ServerSocket();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create ServerSocket.", e);
        }
        InetSocketAddress sa = new InetSocketAddress(port);
        socket.bind(sa);
        try {
            socket.close();
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    public static int getFreePort() {
        return NetUtils.getFreePort(1024, 65535);
    }

    public static int getFreePort(int minPort, int maxPort) {
        int candidatePort;
        int portRange = maxPort - minPort;
        int searchCounter = 0;
        do {
            if (++searchCounter <= portRange) continue;
            throw new IllegalStateException(String.format("There were no ports available in the range %d to %d", minPort, maxPort));
        } while (!NetUtils.isPortAvailable(candidatePort = NetUtils.getRandomPort(minPort, portRange)));
        return candidatePort;
    }

    private static int getRandomPort(int minPort, int portRange) {
        return minPort + random.nextInt(portRange);
    }
}

