/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.remote;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.DuplicateArtifactException;
import org.eclipse.virgo.repository.IndexFormatException;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.XmlArtifactDescriptorPersister;
import org.eclipse.virgo.repository.codec.XMLRepositoryCodec;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.RepositoryLogEvents;
import org.eclipse.virgo.repository.internal.StandardArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.remote.DescriptorStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MutableArtifactDescriptorDepository
implements ArtifactDescriptorDepository {
    private static final Logger LOGGER;
    private final String repositoryName;
    private final EventLogger eventLogger;
    private volatile ArtifactDescriptorDepository delegate;
    private volatile DescriptorStore descriptorStore = null;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.remote.MutableArtifactDescriptorDepository");
        LOGGER = LoggerFactory.getLogger(MutableArtifactDescriptorDepository.class);
    }

    MutableArtifactDescriptorDepository(String repositoryName, EventLogger eventLogger) {
        this.repositoryName = repositoryName;
        this.eventLogger = eventLogger;
    }

    @Override
    public void addArtifactDescriptor(RepositoryAwareArtifactDescriptor artifactDesc) throws DuplicateArtifactException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getArtifactDescriptorCount() {
        ArtifactDescriptorDepository localDelegate = this.delegate;
        if (localDelegate != null) {
            return localDelegate.getArtifactDescriptorCount();
        }
        return 0;
    }

    @Override
    public void persist() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositoryAwareArtifactDescriptor removeArtifactDescriptor(URI uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeArtifactDescriptor(RepositoryAwareArtifactDescriptor artifactDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RepositoryAwareArtifactDescriptor> resolveArtifactDescriptors(Set<Attribute> filters) {
        ArtifactDescriptorDepository localDelegate = this.delegate;
        if (localDelegate != null) {
            return localDelegate.resolveArtifactDescriptors(filters);
        }
        return Collections.emptySet();
    }

    void setDescriptorStore(DescriptorStore descriptorStore) {
        if (descriptorStore == null) {
            this.descriptorStoreUnavailable();
        } else {
            this.descriptorStoreAvailable(descriptorStore);
        }
    }

    private void descriptorStoreUnavailable() {
        DescriptorStore locaDescriptorStore = this.descriptorStore;
        if (locaDescriptorStore != null) {
            this.deleteDescriptorStore(locaDescriptorStore);
            this.eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_TEMPORARILY_UNAVAILABLE, new Object[]{this.repositoryName});
        }
        this.descriptorStore = null;
        this.delegate = null;
    }

    private void descriptorStoreAvailable(DescriptorStore descriptorStore) {
        DescriptorStore localDescriptorStore = this.descriptorStore;
        if (!descriptorStore.equals(localDescriptorStore)) {
            this.newDescriptorStoreAvailable(descriptorStore, localDescriptorStore);
        }
    }

    private void newDescriptorStoreAvailable(DescriptorStore newDescriptorStore, DescriptorStore oldDescriptorStore) {
        ArtifactDescriptorDepository newDelegate = this.createNewDepository(newDescriptorStore);
        if (newDelegate == null) {
            this.deleteDescriptorStore(newDescriptorStore);
            this.deleteDescriptorStore(oldDescriptorStore);
            this.descriptorStoreUnavailable();
        } else {
            this.delegate = newDelegate;
            this.descriptorStore = newDescriptorStore;
            if (oldDescriptorStore == null) {
                this.eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_AVAILABLE, new Object[]{this.repositoryName});
            } else {
                this.eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_INDEX_UPDATED, new Object[]{this.repositoryName});
                this.deleteDescriptorStore(oldDescriptorStore);
            }
        }
    }

    private ArtifactDescriptorDepository createNewDepository(DescriptorStore descriptorStore) {
        XmlArtifactDescriptorPersister persister = new XmlArtifactDescriptorPersister(new XMLRepositoryCodec(), this.repositoryName, descriptorStore.getLocation());
        try {
            return new StandardArtifactDescriptorDepository(persister);
        }
        catch (IndexFormatException indexFormatException) {
            LOGGER.error("The descriptor store for repository '{}' was corrupt", (Object)this.repositoryName);
            return null;
        }
    }

    private void deleteDescriptorStore(DescriptorStore descriptorStore) {
        if (descriptorStore != null && !descriptorStore.getLocation().delete()) {
            LOGGER.warn("Failed to delete descriptor store for repository '{}' from '{}'", (Object)this.repositoryName, (Object)descriptorStore.getLocation().getAbsolutePath());
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

