/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.dispatch;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.eventadmin.impl.dispatch.ThreadPool;
import org.apache.felix.eventadmin.impl.tasks.DeliverTask;
import org.apache.felix.eventadmin.impl.tasks.DispatchTask;

public class CacheThreadPool
implements ThreadPool {
    final Object m_lock = new Object();
    private final PooledThread[] m_pool;
    private final List m_index;
    private boolean m_closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheThreadPool(int size) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_pool = new PooledThread[size];
            this.m_index = new ArrayList(size + 1 + size / 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DispatchTask task, DeliverTask callback) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_closed) {
                PooledThread result = new PooledThread();
                result.reset(task, callback);
                result.release();
                return;
            }
            for (int i = 0; i < this.m_pool.length; ++i) {
                if (null == this.m_pool[i]) {
                    this.m_pool[i] = new PooledThread();
                    this.m_pool[i].reset(task, callback);
                    this.m_index.add(new Integer(i));
                    return;
                }
                if (!this.m_pool[i].available()) continue;
                this.m_pool[i].reset(task, callback);
                Integer idx = new Integer(i);
                this.m_index.remove(idx);
                this.m_index.add(idx);
                return;
            }
            int pos = (Integer)this.m_index.remove(0);
            this.m_index.add(new Integer(pos));
            this.m_pool[pos].release();
            this.m_pool[pos] = new PooledThread();
            this.m_pool[pos].reset(task, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeliverTask getCallback(Thread thread, DeliverTask defaultCallback) {
        Object object = this.m_lock;
        synchronized (object) {
            if (thread instanceof PooledThread) {
                return ((PooledThread)thread).getCallback();
            }
            return defaultCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatchTask getTask(Thread thread, DispatchTask defaultTask) {
        Object object = this.m_lock;
        synchronized (object) {
            if (thread instanceof PooledThread) {
                return ((PooledThread)thread).getTask();
            }
            return defaultTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_lock;
        synchronized (object) {
            for (int i = 0; i < this.m_pool.length; ++i) {
                if (null == this.m_pool[i]) continue;
                this.m_pool[i].release();
                this.m_pool[i] = null;
            }
            this.m_closed = true;
        }
    }

    private class PooledThread
    extends Thread {
        private DispatchTask m_runnable = null;
        private DeliverTask m_callback = null;
        private boolean m_released = false;

        PooledThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DispatchTask next = this.next();
            while (null != next) {
                next.run();
                Object object = CacheThreadPool.this.m_lock;
                synchronized (object) {
                    this.m_runnable = null;
                }
                next = this.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DispatchTask next() {
            Object object = CacheThreadPool.this.m_lock;
            synchronized (object) {
                while (null == this.m_runnable) {
                    if (this.m_released) {
                        return null;
                    }
                    try {
                        CacheThreadPool.this.m_lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.m_runnable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset(DispatchTask next, DeliverTask callback) {
            Object object = CacheThreadPool.this.m_lock;
            synchronized (object) {
                this.m_runnable = next;
                this.m_callback = callback;
                CacheThreadPool.this.m_lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DeliverTask getCallback() {
            Object object = CacheThreadPool.this.m_lock;
            synchronized (object) {
                return this.m_callback;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean available() {
            Object object = CacheThreadPool.this.m_lock;
            synchronized (object) {
                return null == this.m_runnable && !this.m_released;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DispatchTask getTask() {
            Object object = CacheThreadPool.this.m_lock;
            synchronized (object) {
                return this.m_runnable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            Object object = CacheThreadPool.this.m_lock;
            synchronized (object) {
                this.m_released = true;
                CacheThreadPool.this.m_lock.notifyAll();
            }
        }
    }
}

