/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgicommand.helper;

import java.util.HashMap;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingHelper {
    public static boolean isPackageExported(BundleContext bundleContext, String classPackage, Bundle testBundle) {
        ExportPackageDescription[] exportDescriptions;
        ServiceReference reference = bundleContext.getServiceReference(PlatformAdmin.class.getName());
        PlatformAdmin platformAdmin = (PlatformAdmin)bundleContext.getService(reference);
        BundleDescription bundleDescription = platformAdmin.getState(false).getBundle(testBundle.getBundleId());
        ExportPackageDescription[] exportPackageDescriptionArray = exportDescriptions = bundleDescription.getSelectedExports();
        int n = exportDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exportDescription = exportPackageDescriptionArray[n2];
            if (exportDescription.getName().equals(classPackage)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static HashMap<Bundle, Bundle> getBundlesLoadingClass(BundleContext bundleContext, String className) {
        Bundle[] bundles = bundleContext.getBundles();
        HashMap<Bundle, Bundle> foundBundles = new HashMap<Bundle, Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Bundle originBundle = ClassLoadingHelper.originBundleOfClass(className, bundleContext, bundle);
            if (originBundle != null) {
                foundBundles.put(bundle, originBundle);
            }
            ++n2;
        }
        return foundBundles;
    }

    private static Bundle originBundleOfClass(String className, BundleContext bundleContext, Bundle loadingBundle) {
        Class<?> clasz = ClassLoadingHelper.tryToLoadClass(className, loadingBundle);
        Bundle originBundle = null;
        if (clasz != null && (originBundle = FrameworkUtil.getBundle(clasz)) == null) {
            originBundle = bundleContext.getBundle(0L);
        }
        return originBundle;
    }

    public static Class<?> tryToLoadClass(String className, Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static HashMap<Bundle, Bundle> getBundlesLoadingClass(BundleContext bundleContext, String className, String bundle) throws IllegalArgumentException {
        HashMap<Bundle, Bundle> result = new HashMap<Bundle, Bundle>();
        long id = Long.MIN_VALUE;
        try {
            id = Long.parseLong(bundle);
        }
        catch (NumberFormatException numberFormatException) {}
        if (id >= 0L) {
            Bundle testBundle = bundleContext.getBundle(id);
            if (testBundle == null) {
                throw new IllegalArgumentException("Bundle with ID [" + id + "] not found");
            }
            Bundle originBundle = ClassLoadingHelper.originBundleOfClass(className, bundleContext, testBundle);
            if (originBundle != null) {
                result.put(testBundle, originBundle);
            }
        } else {
            ServiceReference reference = bundleContext.getServiceReference(PackageAdmin.class.getName());
            PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(reference);
            Bundle[] bundles = packageAdmin.getBundles(bundle, null);
            if (bundles == null) {
                throw new IllegalArgumentException("Bundle with symbolic name [" + bundle + "] not found");
            }
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle testBundle = bundleArray[n2];
                Bundle originBundle = ClassLoadingHelper.originBundleOfClass(className, bundleContext, testBundle);
                if (originBundle != null) {
                    result.put(testBundle, originBundle);
                }
                ++n2;
            }
        }
        return result;
    }
}

