/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.console.telnet.hook;

import java.io.IOException;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.virgo.osgi.console.telnet.TelnetManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class TelnetHook
implements AdaptorHook {
    private boolean consolePortAvailable;
    private String consoleValue;
    private TelnetManager telnetManager = null;

    public void initialize(BaseAdaptor adaptor) {
        this.consoleValue = FrameworkProperties.getProperty((String)"osgi.console");
        if (this.consoleValue == null) {
            return;
        }
        if (this.consoleValue.contains(":")) {
            this.consolePortAvailable = true;
            FrameworkProperties.getProperties().remove("osgi.console");
        } else {
            try {
                Integer.parseInt(this.consoleValue);
                this.consolePortAvailable = true;
                FrameworkProperties.getProperties().remove("osgi.console");
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        if (this.consolePortAvailable) {
            FrameworkProperties.setProperty((String)"osgi.console", (String)String.valueOf(this.consoleValue));
            this.telnetManager = new TelnetManager(context);
            this.telnetManager.startConsoleListener();
        }
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        if (this.telnetManager != null) {
            this.telnetManager.stop();
        }
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String location) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }
}

