/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.state;

import java.util.Map;
import org.eclipse.virgo.apps.admin.core.BundleHolder;
import org.eclipse.virgo.apps.admin.core.ExportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.ImportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.state.ObjectFormatter;
import org.eclipse.virgo.apps.admin.core.state.StandardBundleHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardExportedPackageHolder;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.shell.state.StateService;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

final class StandardImportedPackageHolder
implements ImportedPackageHolder {
    private final ModuleContextAccessor moduleContextAccessor;
    private final QuasiImportPackage importPackage;
    private final StateService stateService;

    public StandardImportedPackageHolder(QuasiImportPackage importPackage, ModuleContextAccessor moduleContextAccessor, StateService stateService) {
        this.importPackage = importPackage;
        this.moduleContextAccessor = moduleContextAccessor;
        this.stateService = stateService;
    }

    @Override
    public BundleHolder getImportingBundle() {
        QuasiBundle importingBundle = this.importPackage.getImportingBundle();
        if (importingBundle != null) {
            return new StandardBundleHolder(importingBundle, this.moduleContextAccessor, this.stateService);
        }
        return null;
    }

    @Override
    public String getPackageName() {
        return this.importPackage.getPackageName();
    }

    @Override
    public String getVersionConstraint() {
        VersionRange versionConstraint = this.importPackage.getVersionConstraint();
        return versionConstraint.toString().replace("\u221e", "&infin;");
    }

    @Override
    public ExportedPackageHolder getProvider() {
        QuasiExportPackage provider = this.importPackage.getProvider();
        if (provider != null) {
            return new StandardExportedPackageHolder(provider, this.moduleContextAccessor, this.stateService);
        }
        return null;
    }

    @Override
    public boolean isResolved() {
        return this.importPackage.isResolved();
    }

    @Override
    public Map<String, String> getAttributes() {
        return ObjectFormatter.formatMapValues(this.importPackage.getAttributes());
    }

    @Override
    public Map<String, String> getDirectives() {
        return ObjectFormatter.formatMapValues(this.importPackage.getDirectives());
    }
}

