/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel.asm;

import aj.org.objectweb.asm.ClassReader;
import aj.org.objectweb.asm.ClassWriter;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.asm.AsmDetector;

public class StackMapAdder {
    public static byte[] addStackMaps(World world, byte[] data) {
        try {
            ClassReader cr = new ClassReader(data);
            AspectJConnectClassWriter cw = new AspectJConnectClassWriter(world);
            cr.accept(cw, 0);
            return cw.toByteArray();
        }
        catch (Throwable t) {
            System.err.println("AspectJ Internal Error: unable to add stackmap attributes. " + t.getMessage());
            AsmDetector.isAsmAround = false;
            return data;
        }
    }

    private static class AspectJConnectClassWriter
    extends ClassWriter {
        private final World world;

        public AspectJConnectClassWriter(World w) {
            super(2);
            this.world = w;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            ResolvedType resolvedType2;
            ResolvedType resolvedType1 = this.world.resolve(UnresolvedType.forName(type1.replace('/', '.')));
            if (resolvedType1.isAssignableFrom(resolvedType2 = this.world.resolve(UnresolvedType.forName(type2.replace('/', '.'))))) {
                return type1;
            }
            if (resolvedType2.isAssignableFrom(resolvedType1)) {
                return type2;
            }
            if (resolvedType1.isInterface() || resolvedType2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(resolvedType1 = resolvedType1.getSuperclass()).isAssignableFrom(resolvedType2)) {
            }
            return resolvedType1.getName().replace('.', '/');
        }
    }
}

