/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.authentication;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.virgo.kernel.authentication.CredentialStore;
import org.eclipse.virgo.kernel.authentication.Role;
import org.eclipse.virgo.kernel.authentication.User;

final class PropertiesFileCredentialStoreFactory {
    private static final String USER_PREFIX = "user.";
    private static final String ROLE_PREFIX = "role.";

    PropertiesFileCredentialStoreFactory() {
    }

    static CredentialStore create(Properties properties) {
        Map<String, User> credentials = PropertiesFileCredentialStoreFactory.getUsers(properties);
        PropertiesFileCredentialStoreFactory.assignRoles(properties, credentials);
        return new ImmutableCredentialStore(credentials);
    }

    private static Map<String, User> getUsers(Properties properties) {
        HashMap<String, User> users = new HashMap<String, User>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(USER_PREFIX)) continue;
            String username = key.substring(USER_PREFIX.length()).trim();
            String password = properties.getProperty(key);
            users.put(username, new User(username, password));
        }
        return users;
    }

    private static void assignRoles(Properties properties, Map<String, User> credentials) {
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(ROLE_PREFIX)) continue;
            String rolename = key.substring(ROLE_PREFIX.length()).trim();
            Role role = new Role(rolename);
            PropertiesFileCredentialStoreFactory.assignRole(role, (String)properties.get(key), credentials);
        }
    }

    private static void assignRole(Role role, String usernames, Map<String, User> credentials) {
        String[] stringArray = usernames.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String username = stringArray[n2];
            User user = credentials.get(username);
            if (user == null) {
                throw new IllegalArgumentException(String.format("Could not assign role '%s' to user '%s', as user does not exist", role.getName(), username));
            }
            user.addRole(role);
            ++n2;
        }
    }

    private static class ImmutableCredentialStore
    implements CredentialStore {
        private final Map<String, User> credentials;

        public ImmutableCredentialStore(Map<String, User> credentials) {
            this.credentials = credentials;
        }

        @Override
        public User getUser(String name) {
            return this.credentials.get(name);
        }
    }
}

