/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.core.text.build.PropertiesTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.BundleTextChangeListener;
import org.eclipse.pde.internal.core.text.plugin.XMLTextChangeListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.virgo.ide.manifest.core.editor.model.SpringBundleModel;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;
import org.eclipse.virgo.ide.ui.editors.model.BundleModelModification;

public class BundleModelUtility {
    public static final String F_MANIFEST = "MANIFEST.MF";
    public static final String F_MANIFEST_FP = "META-INF/MANIFEST.MF";
    public static final String F_PLUGIN = "plugin.xml";
    public static final String F_FRAGMENT = "fragment.xml";
    public static final String F_PROPERTIES = ".properties";
    public static final String F_BUILD = "build.properties";
    private static final int F_Bi = 0;
    private static final int F_Xi = 1;

    public static void modifyModel(ModelModification modification, IProgressMonitor monitor) {
        if (BundleModelUtility.getFile(modification) == null) {
            return;
        }
        PDEFormEditor editor = BundleModelUtility.getOpenEditor(modification);
        IBaseModel model = BundleModelUtility.getModelFromEditor(editor, modification);
        if (model != null) {
            BundleModelUtility.modifyEditorModel((BundleModelModification)modification, editor, model, monitor);
        } else {
            BundleModelUtility.generateModelEdits((BundleModelModification)modification, monitor, true);
        }
    }

    /*
     * Exception decompiling
     */
    private static TextFileChange[] generateModelEdits(BundleModelModification modification, IProgressMonitor monitor, boolean performEdits) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[DOLOOP]], but top level block is 24[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IBaseModel prepareBundlePluginModel(IFile[] files, IDocument[] docs, boolean generateEditNames) throws CoreException {
        AbstractEditingModel[] models = new AbstractEditingModel[docs.length];
        boolean isFragment = false;
        models[0] = BundleModelUtility.prepareAbstractEditingModel(files[0], docs[0], generateEditNames);
        if (models[0] instanceof IBundleModel) {
            isFragment = ((IBundleModel)models[0]).getBundle().getHeader("Fragment-Host") != null;
        }
        Object pluginModel = isFragment ? new BundleFragmentModel() : new BundlePluginModel();
        pluginModel.setBundleModel((IBundleModel)models[0]);
        if (files.length > 1 && files[1] != null) {
            models[1] = BundleModelUtility.prepareAbstractEditingModel(files[1], docs[1], generateEditNames);
            pluginModel.setExtensionsModel((ISharedExtensionsModel)models[1]);
        }
        return pluginModel;
    }

    private static AbstractEditingModel prepareAbstractEditingModel(IFile file, IDocument doc, boolean generateEditNames) {
        String filename = file.getName();
        if (!filename.equals(F_MANIFEST)) {
            return null;
        }
        SpringBundleModel model = new SpringBundleModel(doc, true);
        model.setUnderlyingResource((IResource)file);
        try {
            model.load();
            IModelTextChangeListener listener = BundleModelUtility.createListener(filename, doc, generateEditNames);
            model.addModelChangedListener((IModelChangedListener)listener);
        }
        catch (CoreException e) {
            PDEPlugin.log((Throwable)e);
        }
        return model;
    }

    private static PDEFormEditor getOpenEditor(ModelModification modification) {
        IProject project = BundleModelUtility.getFile(modification).getProject();
        String name = BundleModelUtility.getFile(modification).getName();
        if (name.equals(F_PLUGIN) || name.equals(F_FRAGMENT) || name.equals(F_MANIFEST) || name.equalsIgnoreCase("template.mf") || name.equalsIgnoreCase("TEST.MF")) {
            return BundleModelUtility.getOpenManifestEditor(project, BundleModelUtility.getFile(modification));
        }
        if (name.equals(F_BUILD)) {
            BuildEditor openEditor = PDEModelUtility.getOpenBuildPropertiesEditor((IProject)project);
            if (openEditor == null) {
                openEditor = BundleModelUtility.getOpenManifestEditor(project, BundleModelUtility.getFile(modification));
            }
            return openEditor;
        }
        return null;
    }

    public static ManifestEditor getOpenManifestEditor(IProject project, IFile file) {
        return (ManifestEditor)BundleModelUtility.getOpenEditor(project, BundleManifestEditor.ID_EDITOR, file);
    }

    private static PDEFormEditor getOpenEditor(IProject project, String editorId, IFile file) {
        ArrayList list = (ArrayList)BundleModelUtility.getOpenPDEEditors().get(project);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            PDEFormEditor editor = (PDEFormEditor)list.get(i);
            if (editor.getEditorSite().getId().equals(editorId) && editor.getEditorInput() instanceof IFileEditorInput && ((IFileEditorInput)editor.getEditorInput()).getFile().equals((Object)file)) {
                return editor;
            }
            ++i;
        }
        return null;
    }

    private static IBaseModel getModelFromEditor(PDEFormEditor openEditor, ModelModification modification) {
        if (openEditor == null) {
            return null;
        }
        String name = BundleModelUtility.getFile(modification).getName();
        IBaseModel model = null;
        if (name.equals(F_PLUGIN) || name.equals(F_FRAGMENT)) {
            model = openEditor.getAggregateModel();
            if (model instanceof IBundlePluginModelBase) {
                model = ((IBundlePluginModelBase)model).getExtensionsModel();
            }
        } else if (name.equals(F_BUILD)) {
            IFormPage page;
            if (openEditor instanceof BuildEditor) {
                model = openEditor.getAggregateModel();
            } else if (openEditor instanceof ManifestEditor && (page = openEditor.findPage("build-context")) instanceof BuildSourcePage) {
                model = ((BuildSourcePage)page).getInputContext().getModel();
            }
        } else if ((name.equals(F_MANIFEST) || name.equalsIgnoreCase("template.mf") || name.equalsIgnoreCase("TEST.MF")) && (model = openEditor.getAggregateModel()) instanceof IBundlePluginModelBase) {
            return model;
        }
        if (model instanceof AbstractEditingModel) {
            return model;
        }
        return null;
    }

    private static void modifyEditorModel(final BundleModelModification mod, final PDEFormEditor editor, final IBaseModel model, final IProgressMonitor monitor) {
        BundleModelUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    IFile[] files;
                    mod.modifySpringBundle(model, monitor);
                    IFile[] iFileArray = files = new IFile[]{BundleModelUtility.getManifestFile(mod), BundleModelUtility.getXMLFile(mod), BundleModelUtility.getPropertiesFile(mod)};
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InputContext con;
                        IFile element = iFileArray[n2];
                        if (element != null && (con = editor.getContextManager().findContext((IResource)element)) != null) {
                            con.flushEditorInput();
                        }
                        ++n2;
                    }
                    if (mod.saveOpenEditor()) {
                        editor.doSave(monitor);
                    }
                }
                catch (Exception e) {
                    PDEPlugin.log((Throwable)e);
                }
            }
        });
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static Hashtable getOpenPDEEditors() {
        try {
            Field openEditorsField = PDEModelUtility.class.getDeclaredField("fOpenPDEEditors");
            openEditorsField.setAccessible(true);
            Hashtable openEditors = (Hashtable)openEditorsField.get(null);
            return openEditors;
        }
        catch (Exception e) {
            return new Hashtable();
        }
    }

    private static IFile getFile(ModelModification mod) {
        Object obj;
        block4: {
            try {
                Method getFileMethod = ModelModification.class.getDeclaredMethod("getFile", null);
                getFileMethod.setAccessible(true);
                obj = getFileMethod.invoke((Object)mod, null);
                if (obj != null) break block4;
                if (mod instanceof BundleModelModification) {
                    return ((BundleModelModification)mod).getIfile();
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return (IFile)obj;
    }

    private static IFile getManifestFile(ModelModification mod) {
        try {
            Method getFileMethod = ModelModification.class.getDeclaredMethod("getManifestFile", null);
            getFileMethod.setAccessible(true);
            Object obj = getFileMethod.invoke((Object)mod, null);
            if (obj instanceof IFile) {
                return (IFile)obj;
            }
            if (mod instanceof BundleModelModification) {
                return ((BundleModelModification)mod).getIfile();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static IFile getXMLFile(ModelModification mod) {
        try {
            Method getFileMethod = ModelModification.class.getDeclaredMethod("getXMLFile", null);
            getFileMethod.setAccessible(true);
            Object obj = getFileMethod.invoke((Object)mod, null);
            if (obj instanceof IFile) {
                return (IFile)obj;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static IFile getPropertiesFile(ModelModification mod) {
        try {
            Method getFileMethod = ModelModification.class.getDeclaredMethod("getPropertiesFile", null);
            getFileMethod.setAccessible(true);
            Object obj = getFileMethod.invoke((Object)mod, null);
            if (obj instanceof IFile) {
                return (IFile)obj;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isFullBundleModification(ModelModification mod) {
        try {
            Method getBooleanMethod = ModelModification.class.getDeclaredMethod("isFullBundleModification", null);
            getBooleanMethod.setAccessible(true);
            Object obj = getBooleanMethod.invoke((Object)mod, null);
            if (obj instanceof Boolean) {
                Boolean bool = (Boolean)obj;
                return bool;
            }
            if (mod instanceof BundleModelModification) {
                IFile file = ((BundleModelModification)mod).getIfile();
                return file.getName().equals(F_MANIFEST);
            }
            return false;
        }
        catch (Exception e) {
            if (mod instanceof BundleModelModification) {
                IFile file = ((BundleModelModification)mod).getIfile();
                return file.getName().equals(F_MANIFEST);
            }
            return false;
        }
    }

    private static IModelTextChangeListener[] gatherListeners(IBaseModel editModel) {
        IModelTextChangeListener[] listeners = new IModelTextChangeListener[]{};
        if (editModel instanceof AbstractEditingModel) {
            listeners = new IModelTextChangeListener[]{((AbstractEditingModel)editModel).getLastTextChangeListener()};
        }
        if (editModel instanceof IBundlePluginModelBase) {
            IBundlePluginModelBase modelBase = (IBundlePluginModelBase)editModel;
            listeners = new IModelTextChangeListener[]{BundleModelUtility.gatherListener((IBaseModel)modelBase.getBundleModel()), BundleModelUtility.gatherListener((IBaseModel)modelBase.getExtensionsModel())};
            return listeners;
        }
        return listeners;
    }

    private static IModelTextChangeListener createListener(String filename, IDocument doc, boolean generateEditNames) {
        if (filename.equals(F_PLUGIN) || filename.equals(F_FRAGMENT)) {
            return new XMLTextChangeListener(doc, generateEditNames);
        }
        if (filename.equals(F_MANIFEST)) {
            return new BundleTextChangeListener(doc, generateEditNames);
        }
        if (filename.endsWith(F_PROPERTIES)) {
            return new PropertiesTextChangeListener(doc, generateEditNames);
        }
        return null;
    }

    private static IModelTextChangeListener gatherListener(IBaseModel model) {
        if (model instanceof AbstractEditingModel) {
            return ((AbstractEditingModel)model).getLastTextChangeListener();
        }
        return null;
    }
}

