/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.jdt.core.JdtCorePlugin;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainer;
import org.eclipse.virgo.ide.jdt.internal.core.util.ClasspathUtils;

public class EnableServerClasspathContainerActionDelegate
implements IObjectActionDelegate {
    private final List<IProject> selected = new ArrayList<IProject>();

    public void run(IAction action) {
        LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
        for (IProject project : this.selected) {
            if (FacetUtils.isBundleProject((IResource)project)) {
                projects.add(JavaCore.create((IProject)project));
                continue;
            }
            if (!FacetUtils.isParProject((IResource)project)) continue;
            IProject[] iProjectArray = FacetUtils.getBundleProjects((IProject)project);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject bundle = iProjectArray[n2];
                projects.add(JavaCore.create((IProject)bundle));
                ++n2;
            }
        }
        for (IJavaProject javaProject : projects) {
            try {
                if (ClasspathUtils.hasClasspathContainer((IJavaProject)javaProject)) {
                    this.removeFromClasspath(javaProject, JavaCore.newContainerEntry((IPath)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH, null, (IClasspathAttribute[])ServerClasspathContainer.CLASSPATH_CONTAINER_ATTRIBUTE, (boolean)false), (IProgressMonitor)new NullProgressMonitor());
                    javaProject.getProject().deleteMarkers("org.eclipse.virgo.ide.jdt.core.dependencyproblemmarker", true, 2);
                    continue;
                }
                this.addToClasspath(javaProject, JavaCore.newContainerEntry((IPath)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH, null, (IClasspathAttribute[])ServerClasspathContainer.CLASSPATH_CONTAINER_ATTRIBUTE, (boolean)false), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JdtCorePlugin.log((Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    if (!project.isOpen()) {
                        enabled = false;
                        break;
                    }
                    this.selected.add(project);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        }
    }

    private void addToClasspath(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] current = javaProject.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length + 1];
        System.arraycopy(current, 0, updated, 0, current.length);
        updated[current.length] = entry;
        javaProject.setRawClasspath(updated, monitor);
    }

    protected void removeFromClasspath(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<IClasspathEntry> entries = new LinkedHashSet<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry existingEntry = iClasspathEntryArray[n2];
            if (!existingEntry.equals(entry)) {
                entries.add(existingEntry);
            }
            ++n2;
        }
        javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), monitor);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

