/**
 * 
 *   Copyright (c) 2010-2013, Abel Hegedus, Zoltan Ujhelyi, Denes Harmath, Istvan Rath and Daniel Varro, IncQuery Labs Ltd.
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.integration.uml.derivedfeatures.internal;

import org.eclipse.viatra.integration.uml.derivedfeatures.ActionContext;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActionInput;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActionOutput;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityEdgeInGroup;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityGroup;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityGroupContainedEdge;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityGroupContainedNode;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityGroupInActivity;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityGroupSubgroup;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityGroupSuperGroup;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityNode;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityNodeActivity;
import org.eclipse.viatra.integration.uml.derivedfeatures.ActivityNodeInGroup;
import org.eclipse.viatra.integration.uml.derivedfeatures.AssociationEndType;
import org.eclipse.viatra.integration.uml.derivedfeatures.BehaviorContext;
import org.eclipse.viatra.integration.uml.derivedfeatures.ClassExtension;
import org.eclipse.viatra.integration.uml.derivedfeatures.ClassSuperClass;
import org.eclipse.viatra.integration.uml.derivedfeatures.ClassifierAttribute;
import org.eclipse.viatra.integration.uml.derivedfeatures.ClassifierFeature;
import org.eclipse.viatra.integration.uml.derivedfeatures.ClassifierGeneral;
import org.eclipse.viatra.integration.uml.derivedfeatures.ConnectableElementEnd;
import org.eclipse.viatra.integration.uml.derivedfeatures.ConnectorKind;
import org.eclipse.viatra.integration.uml.derivedfeatures.DeploymentTargetDeployedElement;
import org.eclipse.viatra.integration.uml.derivedfeatures.DirectedRelationshipSource;
import org.eclipse.viatra.integration.uml.derivedfeatures.DirectedRelationshipTarget;
import org.eclipse.viatra.integration.uml.derivedfeatures.ElementOwnedElement;
import org.eclipse.viatra.integration.uml.derivedfeatures.ElementOwner;
import org.eclipse.viatra.integration.uml.derivedfeatures.EncapsulatedClassifierOwnedPort;
import org.eclipse.viatra.integration.uml.derivedfeatures.ExtensionMetaclass;
import org.eclipse.viatra.integration.uml.derivedfeatures.FeatureFeaturingClassifier;
import org.eclipse.viatra.integration.uml.derivedfeatures.MessageMessageKind;
import org.eclipse.viatra.integration.uml.derivedfeatures.NamedElementClientDependency;
import org.eclipse.viatra.integration.uml.derivedfeatures.NamedElementNamespace;
import org.eclipse.viatra.integration.uml.derivedfeatures.NamedElementQualifiedName;
import org.eclipse.viatra.integration.uml.derivedfeatures.NamespaceImportedMember;
import org.eclipse.viatra.integration.uml.derivedfeatures.NamespaceMember;
import org.eclipse.viatra.integration.uml.derivedfeatures.NamespaceOwnedMember;
import org.eclipse.viatra.integration.uml.derivedfeatures.OpaqueExpressionResult;
import org.eclipse.viatra.integration.uml.derivedfeatures.PackageNestedPackage;
import org.eclipse.viatra.integration.uml.derivedfeatures.PackageNestingPackage;
import org.eclipse.viatra.integration.uml.derivedfeatures.PackageOwnedStereotype;
import org.eclipse.viatra.integration.uml.derivedfeatures.PackageOwnedType;
import org.eclipse.viatra.integration.uml.derivedfeatures.PropertyIsComposite;
import org.eclipse.viatra.integration.uml.derivedfeatures.ProtocolTransitionReferred;
import org.eclipse.viatra.integration.uml.derivedfeatures.RedefinableElementRedefinedElement;
import org.eclipse.viatra.integration.uml.derivedfeatures.RedefinableElementRedefinitionContext;
import org.eclipse.viatra.integration.uml.derivedfeatures.RedefinableTemplateSignatureInheritedParameter;
import org.eclipse.viatra.integration.uml.derivedfeatures.RelationshipRelatedElement;
import org.eclipse.viatra.integration.uml.derivedfeatures.StateIsComposite;
import org.eclipse.viatra.integration.uml.derivedfeatures.StateIsOrthogonal;
import org.eclipse.viatra.integration.uml.derivedfeatures.StructuredClassifierPart;
import org.eclipse.viatra.integration.uml.derivedfeatures.StructuredClassifierRole;
import org.eclipse.viatra.integration.uml.derivedfeatures.TypePackage;
import org.eclipse.viatra.integration.uml.derivedfeatures.VertexIncoming;
import org.eclipse.viatra.integration.uml.derivedfeatures.VertexOutgoing;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;

/**
 * A pattern group formed of all patterns defined in DerivedFeatures.vql.
 * 
 * <p>A private group that includes private patterns as well. Only intended use case is for pattern testing.
 * 
 * <p> From package org.eclipse.viatra.integration.uml.derivedfeatures, the group contains the definition of the following patterns: <ul>
 * <li>actionInput</li>
 * <li>actionOutput</li>
 * <li>activityGroup</li>
 * <li>activityGroupInActivity</li>
 * <li>activityNode</li>
 * <li>activityNodeActivity</li>
 * <li>activityEdgeInGroup</li>
 * <li>activityGroupContainedEdge</li>
 * <li>activityGroupContainedNode</li>
 * <li>activityNodeInGroup</li>
 * <li>activityGroupSubgroup</li>
 * <li>activityGroupSuperGroup</li>
 * <li>classifierAttribute</li>
 * <li>classifierFeature</li>
 * <li>featureFeaturingClassifier</li>
 * <li>directedRelationshipSource</li>
 * <li>directedRelationshipTarget</li>
 * <li>elementOwnedElement</li>
 * <li>elementOwner</li>
 * <li>propertyClass</li>
 * <li>namespaceMember</li>
 * <li>namespaceOwnedMember</li>
 * <li>redefinableElementRedefinedElement</li>
 * <li>redefinableElementRedefinitionContext</li>
 * <li>regionRedefinitionContext</li>
 * <li>stateRedefinitionContext</li>
 * <li>transitionRedefinitionContext</li>
 * <li>relationshipRelatedElement</li>
 * <li>structuredClassifierRole</li>
 * <li>actionContext</li>
 * <li>associationEndType</li>
 * <li>behaviorContext</li>
 * <li>internalBehaviorContext</li>
 * <li>intermediateBehaviorClassifier</li>
 * <li>nestedClassifier</li>
 * <li>connectableElementEnd</li>
 * <li>deploymentTargetDeployedElement</li>
 * <li>namedElementClientDependency</li>
 * <li>protocolTransitionReferred</li>
 * <li>vertexIncoming</li>
 * <li>vertexOutgoing</li>
 * <li>connectorKind</li>
 * <li>connectorKindDelegation</li>
 * <li>connectorEndPartWithPort</li>
 * <li>messageMessageKind</li>
 * <li>messageSendEvent</li>
 * <li>messageReceiveEvent</li>
 * <li>packageNestedPackage</li>
 * <li>packageOwnedStereotype</li>
 * <li>packageOwnedType</li>
 * <li>propertyIsComposite</li>
 * <li>stateIsComposite</li>
 * <li>stateIsComposite_0</li>
 * <li>namedElementNamespace</li>
 * <li>typePackage</li>
 * <li>classExtension</li>
 * <li>typeOrAllParents</li>
 * <li>classSuperClass</li>
 * <li>classifierAllParents</li>
 * <li>classifierGeneral</li>
 * <li>isClass</li>
 * <li>encapsulatedClassifierOwnedPort</li>
 * <li>extensionMetaclass</li>
 * <li>extensionMetaclassEnd</li>
 * <li>extensionOwnedEnd</li>
 * <li>namedElementQualifiedName</li>
 * <li>internalNamedElementNamespace</li>
 * <li>namespaceImportedMember</li>
 * <li>opaqueExpressionResult</li>
 * <li>packageVisibleMember</li>
 * <li>packageDirectlyVisibleMember</li>
 * <li>packageAllImportedPackages</li>
 * <li>packageImportedPackage</li>
 * <li>packageNestingPackage</li>
 * <li>redefinableTemplateSignatureInheritedParameter</li>
 * <li>structuredClassifierPart</li>
 * <li>stateIsOrthogonal</li>
 * <li>actionContainingBehavior</li>
 * <li>classifierParents</li>
 * <li>regionContainingStateMachine</li>
 * <li>transitionContainingStateMachine</li>
 * <li>vertexContainingStateMachine</li>
 * <li>stateMachineContainment</li>
 * </ul>
 * 
 * @see IQueryGroup
 * 
 */
@SuppressWarnings("all")
public final class DerivedFeaturesAll extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryRuntimeException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static DerivedFeaturesAll instance() {
    if (INSTANCE == null) {
        INSTANCE = new DerivedFeaturesAll();
    }
    return INSTANCE;
  }

  private static DerivedFeaturesAll INSTANCE;

  private DerivedFeaturesAll() {
    querySpecifications.add(ActionInput.instance());
    querySpecifications.add(ActionOutput.instance());
    querySpecifications.add(ActivityGroup.instance());
    querySpecifications.add(ActivityGroupInActivity.instance());
    querySpecifications.add(ActivityNode.instance());
    querySpecifications.add(ActivityNodeActivity.instance());
    querySpecifications.add(ActivityEdgeInGroup.instance());
    querySpecifications.add(ActivityGroupContainedEdge.instance());
    querySpecifications.add(ActivityGroupContainedNode.instance());
    querySpecifications.add(ActivityNodeInGroup.instance());
    querySpecifications.add(ActivityGroupSubgroup.instance());
    querySpecifications.add(ActivityGroupSuperGroup.instance());
    querySpecifications.add(ClassifierAttribute.instance());
    querySpecifications.add(ClassifierFeature.instance());
    querySpecifications.add(FeatureFeaturingClassifier.instance());
    querySpecifications.add(DirectedRelationshipSource.instance());
    querySpecifications.add(DirectedRelationshipTarget.instance());
    querySpecifications.add(ElementOwnedElement.instance());
    querySpecifications.add(ElementOwner.instance());
    querySpecifications.add(PropertyClass.instance());
    querySpecifications.add(NamespaceMember.instance());
    querySpecifications.add(NamespaceOwnedMember.instance());
    querySpecifications.add(RedefinableElementRedefinedElement.instance());
    querySpecifications.add(RedefinableElementRedefinitionContext.instance());
    querySpecifications.add(RegionRedefinitionContext.instance());
    querySpecifications.add(StateRedefinitionContext.instance());
    querySpecifications.add(TransitionRedefinitionContext.instance());
    querySpecifications.add(RelationshipRelatedElement.instance());
    querySpecifications.add(StructuredClassifierRole.instance());
    querySpecifications.add(ActionContext.instance());
    querySpecifications.add(AssociationEndType.instance());
    querySpecifications.add(BehaviorContext.instance());
    querySpecifications.add(InternalBehaviorContext.instance());
    querySpecifications.add(IntermediateBehaviorClassifier.instance());
    querySpecifications.add(NestedClassifier.instance());
    querySpecifications.add(ConnectableElementEnd.instance());
    querySpecifications.add(DeploymentTargetDeployedElement.instance());
    querySpecifications.add(NamedElementClientDependency.instance());
    querySpecifications.add(ProtocolTransitionReferred.instance());
    querySpecifications.add(VertexIncoming.instance());
    querySpecifications.add(VertexOutgoing.instance());
    querySpecifications.add(ConnectorKind.instance());
    querySpecifications.add(ConnectorKindDelegation.instance());
    querySpecifications.add(ConnectorEndPartWithPort.instance());
    querySpecifications.add(MessageMessageKind.instance());
    querySpecifications.add(MessageSendEvent.instance());
    querySpecifications.add(MessageReceiveEvent.instance());
    querySpecifications.add(PackageNestedPackage.instance());
    querySpecifications.add(PackageOwnedStereotype.instance());
    querySpecifications.add(PackageOwnedType.instance());
    querySpecifications.add(PropertyIsComposite.instance());
    querySpecifications.add(StateIsComposite.instance());
    querySpecifications.add(StateIsComposite_0.instance());
    querySpecifications.add(NamedElementNamespace.instance());
    querySpecifications.add(TypePackage.instance());
    querySpecifications.add(ClassExtension.instance());
    querySpecifications.add(TypeOrAllParents.instance());
    querySpecifications.add(ClassSuperClass.instance());
    querySpecifications.add(ClassifierAllParents.instance());
    querySpecifications.add(ClassifierGeneral.instance());
    querySpecifications.add(IsClass.instance());
    querySpecifications.add(EncapsulatedClassifierOwnedPort.instance());
    querySpecifications.add(ExtensionMetaclass.instance());
    querySpecifications.add(ExtensionMetaclassEnd.instance());
    querySpecifications.add(ExtensionOwnedEnd.instance());
    querySpecifications.add(NamedElementQualifiedName.instance());
    querySpecifications.add(InternalNamedElementNamespace.instance());
    querySpecifications.add(NamespaceImportedMember.instance());
    querySpecifications.add(OpaqueExpressionResult.instance());
    querySpecifications.add(PackageVisibleMember.instance());
    querySpecifications.add(PackageDirectlyVisibleMember.instance());
    querySpecifications.add(PackageAllImportedPackages.instance());
    querySpecifications.add(PackageImportedPackage.instance());
    querySpecifications.add(PackageNestingPackage.instance());
    querySpecifications.add(RedefinableTemplateSignatureInheritedParameter.instance());
    querySpecifications.add(StructuredClassifierPart.instance());
    querySpecifications.add(StateIsOrthogonal.instance());
    querySpecifications.add(ActionContainingBehavior.instance());
    querySpecifications.add(ClassifierParents.instance());
    querySpecifications.add(RegionContainingStateMachine.instance());
    querySpecifications.add(TransitionContainingStateMachine.instance());
    querySpecifications.add(VertexContainingStateMachine.instance());
    querySpecifications.add(StateMachineContainment.instance());
  }
}
