/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelElement;
import org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.TransformationModelElementLabelProvider;
import org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.properties.CrossReferenceElementPropertySource;

public class CrossReferencePropertySource
implements IPropertySource {
    private final List<TransformationModelElement> elements;

    public CrossReferencePropertySource(List<TransformationModelElement> elements) {
        this.elements = elements;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList descriptors = Lists.newArrayList();
        for (TransformationModelElement element : this.elements) {
            Integer indexOf = this.elements.indexOf(element);
            PropertyDescriptor descriptor = new PropertyDescriptor((Object)indexOf, "[" + String.valueOf(indexOf) + "]");
            descriptor.setLabelProvider((ILabelProvider)new TransformationModelElementLabelProvider());
            descriptors.add(descriptor);
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof Integer) {
            return new CrossReferenceElementPropertySource(this.elements.get((Integer)id));
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

