/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.single;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorBucketNode;
import org.eclipse.viatra.query.runtime.rete.single.SingleInputNode;

public class DiscriminatorDispatcherNode
extends SingleInputNode
implements NetworkStructureChangeSensitiveNode {
    private int discriminationColumnIndex;
    private Map<Object, DiscriminatorBucketNode> buckets = new HashMap<Object, DiscriminatorBucketNode>();
    private Map<Object, Mailbox> bucketMailboxes = new HashMap<Object, Mailbox>();

    public DiscriminatorDispatcherNode(ReteContainer reteContainer, int discriminationColumnIndex) {
        super(reteContainer);
        this.discriminationColumnIndex = discriminationColumnIndex;
    }

    @Override
    public void update(Direction direction, Tuple updateElement, Timestamp timestamp) {
        Object dispatchKey = updateElement.get(this.discriminationColumnIndex);
        Mailbox bucketMailBox = this.bucketMailboxes.get(dispatchKey);
        if (bucketMailBox != null) {
            bucketMailBox.postMessage(direction, updateElement, timestamp);
        }
    }

    public int getDiscriminationColumnIndex() {
        return this.discriminationColumnIndex;
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        this.propagatePullInto(collector, flush);
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        this.propagatePullIntoWithTimestamp(collector, flush);
    }

    public void pullIntoFiltered(Collection<Tuple> collector, Object bucketKey, boolean flush) {
        ArrayList<Tuple> unfiltered = new ArrayList<Tuple>();
        this.propagatePullInto(unfiltered, flush);
        for (Tuple tuple : unfiltered) {
            if (!bucketKey.equals(tuple.get(this.discriminationColumnIndex))) continue;
            collector.add(tuple);
        }
    }

    public void pullIntoWithTimestampFiltered(Map<Tuple, Timeline<Timestamp>> collector, Object bucketKey, boolean flush) {
        Map unfiltered = CollectionsFactory.createMap();
        this.propagatePullIntoWithTimestamp(unfiltered, flush);
        for (Map.Entry entry : unfiltered.entrySet()) {
            if (!bucketKey.equals(((Tuple)entry.getKey()).get(this.discriminationColumnIndex))) continue;
            collector.put((Tuple)entry.getKey(), (Timeline<Timestamp>)((Timeline)entry.getValue()));
        }
    }

    @Override
    public void appendChild(Receiver receiver) {
        super.appendChild(receiver);
        if (receiver instanceof DiscriminatorBucketNode) {
            DiscriminatorBucketNode bucket = (DiscriminatorBucketNode)receiver;
            Object bucketKey = bucket.getBucketKey();
            DiscriminatorBucketNode old = this.buckets.put(bucketKey, bucket);
            if (old != null) {
                throw new IllegalStateException();
            }
            this.bucketMailboxes.put(bucketKey, this.getCommunicationTracker().proxifyMailbox(this, bucket.getMailbox()));
        }
    }

    public Map<Object, Mailbox> getBucketMailboxes() {
        return this.bucketMailboxes;
    }

    @Override
    public void networkStructureChanged() {
        this.bucketMailboxes.clear();
        for (Receiver receiver : this.children) {
            if (!(receiver instanceof DiscriminatorBucketNode)) continue;
            DiscriminatorBucketNode bucket = (DiscriminatorBucketNode)receiver;
            Object bucketKey = bucket.getBucketKey();
            this.bucketMailboxes.put(bucketKey, this.getCommunicationTracker().proxifyMailbox(this, bucket.getMailbox()));
        }
    }

    @Override
    public void removeChild(Receiver receiver) {
        super.removeChild(receiver);
        if (receiver instanceof DiscriminatorBucketNode) {
            DiscriminatorBucketNode bucket = (DiscriminatorBucketNode)receiver;
            Object bucketKey = bucket.getBucketKey();
            DiscriminatorBucketNode old = this.buckets.remove(bucketKey);
            if (old != bucket) {
                throw new IllegalStateException();
            }
            this.bucketMailboxes.remove(bucketKey);
        }
    }

    @Override
    protected String toStringCore() {
        return super.toStringCore() + "<" + this.discriminationColumnIndex + ">";
    }
}

