/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.tooling.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.tooling.ui.ViewersToolingPlugin;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.ViewersMultiSandboxViewComponent;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public class ViewersMultiSandboxView
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "org.eclipse.viatra.addon.viewers.tooling.ui.sandbox";
    private ViewersMultiSandboxViewComponent defaultComponent;
    private List<ViewersMultiSandboxViewComponent> additionalComponents = new ArrayList<ViewersMultiSandboxViewComponent>();
    private ViewersMultiSandboxViewComponent currentComponent;
    SashForm container;
    private Action getCloseCurrentComponentAction = new Action("Close current component"){
        {
            this.setImageDescriptor(ViewersToolingPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.tooling.ui", (String)"icons/collapse.gif"));
        }

        public void run() {
            if (!ViewersMultiSandboxView.this.defaultComponent.equals(ViewersMultiSandboxView.this.currentComponent)) {
                ViewersMultiSandboxViewComponent target = ViewersMultiSandboxView.this.getCurrentComponent();
                ViewersMultiSandboxView.this.setCurrentComponent(ViewersMultiSandboxView.this.defaultComponent);
                for (ISelectionChangedListener l : ViewersMultiSandboxView.this.defaultComponent.selectionHelper.getSelectionChangedListeners()) {
                    target.removeSelectionChangedListener(l);
                }
                target.dispose();
                ViewersMultiSandboxView.this.additionalComponents.remove(target);
                ViewersMultiSandboxView.this.container.layout();
            }
        }
    };
    private Action getAddNewComponentAction = new Action("Create new component"){
        {
            this.setImageDescriptor(ViewersToolingPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.tooling.ui", (String)"icons/expand.gif"));
        }

        public void run() {
            ViewersMultiSandboxViewComponent newC = new ViewersMultiSandboxViewComponent(ViewersMultiSandboxView.this);
            ViewersMultiSandboxView.this.additionalComponents.add(newC);
            for (ISelectionChangedListener l : ViewersMultiSandboxView.this.defaultComponent.selectionHelper.getSelectionChangedListeners()) {
                newC.addSelectionChangedListener(l);
            }
            try {
                newC.initializeContents(ViewersMultiSandboxView.this.defaultComponent.initialConfiguration);
            }
            catch (ViatraQueryException e) {
                ViewersMultiSandboxView.log("addNewComponentAction.run", (Exception)((Object)e));
            }
            ViewersMultiSandboxView.this.container.layout();
        }
    };
    boolean isVerticalSashing = true;
    private Action getSwitchSashingAction = new Action("Switch between horizontal and vertical mode", 2){
        {
            this.setState();
        }

        public void run() {
            boolean bl = ViewersMultiSandboxView.this.isVerticalSashing = !ViewersMultiSandboxView.this.isVerticalSashing;
            if (ViewersMultiSandboxView.this.isVerticalSashing) {
                ViewersMultiSandboxView.this.container.setOrientation(512);
            } else {
                ViewersMultiSandboxView.this.container.setOrientation(256);
            }
            this.setState();
        }

        void setState() {
            this.setChecked(ViewersMultiSandboxView.this.isVerticalSashing);
            if (ViewersMultiSandboxView.this.isVerticalSashing) {
                this.setImageDescriptor(ViewersToolingPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.tooling.ui", (String)"icons/vertical.gif"));
            } else {
                this.setImageDescriptor(ViewersToolingPlugin.imageDescriptorFromPlugin((String)"org.eclipse.viatra.addon.viewers.tooling.ui", (String)"icons/horizontal.gif"));
            }
        }
    };
    private final ISelectionListener forwardRevealListener = (part, selection) -> {
        if (!((Object)((Object)this)).equals(part) && selection instanceof IStructuredSelection) {
            ArrayList<Notifier> r = new ArrayList<Notifier>();
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object _target = objectArray[n2];
                if (_target instanceof Notifier) {
                    r.add((Notifier)_target);
                }
                ++n2;
            }
            this.setSelection((ISelection)new StructuredSelection(r));
        }
    };

    static void log(String message) {
        ViewersToolingPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.viatra.addon.viewers.tooling.ui", message));
    }

    static void log(String methodname, Exception e) {
        ViewersToolingPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.viatra.addon.viewers.tooling.ui", e.getLocalizedMessage(), (Throwable)e));
    }

    public void initializeContents(EMFScope model, Collection<IQuerySpecification<?>> queries, ViewerDataFilter filter) {
        if (model != null) {
            this.defaultComponent.initializeContents(model, queries, filter);
            for (ViewersMultiSandboxViewComponent c : this.additionalComponents) {
                c.initializeContents(model, queries, filter);
            }
        }
    }

    public static ViewersMultiSandboxView getInstance() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
            return (ViewersMultiSandboxView)activeWorkbenchWindow.getActivePage().findView(ID);
        }
        return null;
    }

    public static void ensureOpen() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
            try {
                activeWorkbenchWindow.getActivePage().showView(ID);
            }
            catch (PartInitException e) {
                ViewersMultiSandboxView.log("ensureOpen", (Exception)((Object)e));
            }
        }
    }

    protected ViewersMultiSandboxViewComponent getCurrentComponent() {
        return this.currentComponent;
    }

    protected void setCurrentComponent(ViewersMultiSandboxViewComponent newCurrent) {
        ViewersMultiSandboxViewComponent previous = this.getCurrentComponent();
        if (previous != null) {
            previous.setBackGround();
        }
        this.currentComponent = newCurrent;
        newCurrent.setForeground();
        this.fillToolBar(newCurrent);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        this.container = new SashForm(parent, 512);
        this.defaultComponent = new ViewersMultiSandboxViewComponent(this);
        this.defaultComponent.setForeground();
        this.currentComponent = this.defaultComponent;
        this.fillToolBar(this.getCurrentComponent());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getSite().getPage().addSelectionListener(this.forwardRevealListener);
    }

    public void dispose() {
        this.defaultComponent.dispose();
        for (ViewersMultiSandboxViewComponent c : this.additionalComponents) {
            c.dispose();
        }
        this.getSite().getPage().removeSelectionListener(this.forwardRevealListener);
        super.dispose();
    }

    public void setFocus() {
        if (this.getCurrentComponent() != null) {
            this.getCurrentComponent().setFocus();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            PropertySheetPage propertySheetPage = new PropertySheetPage();
            propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)));
            return adapter.cast(propertySheetPage);
        }
        return (T)super.getAdapter(adapter);
    }

    void fillToolBar(ViewersMultiSandboxViewComponent c) {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.removeAll();
        mgr.add((IAction)this.getSwitchSashingAction);
        mgr.add((IAction)this.getAddNewComponentAction);
        mgr.add((IAction)this.getCloseCurrentComponentAction);
        mgr.add((IContributionItem)new Separator());
        c.fillToolBarBasedOnCurrentTab();
        this.getViewSite().getActionBars().updateActionBars();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.defaultComponent.addSelectionChangedListener(listener);
        for (ViewersMultiSandboxViewComponent c : this.additionalComponents) {
            c.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        return this.getCurrentComponent().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.defaultComponent.removeSelectionChangedListener(listener);
        for (ViewersMultiSandboxViewComponent c : this.additionalComponents) {
            c.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.getCurrentComponent().setSelection(selection);
    }
}

