/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check.nobase;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;

public class ScopeCheck
implements ISearchOperation {
    private int position;
    private EMFScope scope;

    public ScopeCheck(int position, EMFScope scope) {
        this.position = position;
        this.scope = scope;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check    +" + variableMapping.apply(this.position) + " in scope " + this.scope;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position);
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            Objects.requireNonNull(frame.getValue(ScopeCheck.this.position), () -> String.format("Invalid plan, variable %d unbound", ScopeCheck.this.position));
            Object value = frame.getValue(ScopeCheck.this.position);
            if (value instanceof EObject) {
                EObject eObject = (EObject)value;
                IBaseIndexObjectFilter filterConfiguration = ScopeCheck.this.scope.getOptions().getObjectFilterConfiguration();
                boolean filtered = false;
                if (filterConfiguration != null) {
                    filtered = filterConfiguration.isFiltered((Notifier)eObject);
                }
                if (filtered) {
                    return false;
                }
                return EcoreUtil.isAncestor((Collection)ScopeCheck.this.scope.getScopeRoots(), (EObject)eObject);
            }
            return true;
        }

        @Override
        public ISearchOperation getOperation() {
            return ScopeCheck.this;
        }
    }
}

