/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.statecoding;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.dse.statecoding.IObjectsProvider;
import org.eclipse.viatra.dse.statecoding.StatecodingDependency;
import org.eclipse.viatra.dse.statecoding.StatecodingDependencyGraph;
import org.eclipse.viatra.dse.statecoding.StatecodingDependencyType;
import org.eclipse.viatra.dse.statecoding.StatecodingNode;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;

public class TheStateCoder
implements IStateCoder {
    private StatecodingDependencyGraph sdg;
    private IObjectsProvider objectProvider;

    public TheStateCoder(StatecodingDependencyGraph sdg, IObjectsProvider objectProvider) {
        this.sdg = sdg;
        this.objectProvider = objectProvider;
    }

    @Override
    public void init(Notifier notifier) {
        this.objectProvider.init(notifier, this.sdg);
    }

    @Override
    public String createStateCode() {
        StringBuilder sb = new StringBuilder();
        for (StatecodingNode node : this.sdg.getNodes()) {
            sb.append(node.getClazz().getName());
            sb.append(':');
            sb.append(this.addStateCode(node));
            sb.append('|');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public Object createActivationCode(IPatternMatch match) {
        Object object;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        do {
            if ((object = match.get(i++)) == null || !(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            sb.append(this.addStateCode(this.sdg.getNodeByClass(eObject.eClass()), eObject));
        } while (object != null);
        return sb.toString();
    }

    public String addStateCode(StatecodingNode node, EObject eObject) {
        List<StatecodingDependency> dependencies;
        int dependenciesSize;
        StringBuilder sb = new StringBuilder();
        Set<EAttribute> attributes = node.getAttributes();
        if (!attributes.isEmpty()) {
            for (EAttribute eAttribute : attributes) {
                sb.append(eObject.eGet((EStructuralFeature)eAttribute));
                sb.append(';');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        if ((dependenciesSize = (dependencies = node.getStatecodingDependencies()).size()) > 0) {
            Object[] codeParts = new String[dependenciesSize];
            int i = 0;
            for (StatecodingDependency dependency : dependencies) {
                String code = this.addStateCodeFromDependency(dependency, eObject);
                codeParts[i++] = code;
            }
            Arrays.sort(codeParts);
            sb.append("(");
            sb.append((String)codeParts[0]);
            i = 1;
            while (i < codeParts.length) {
                sb.append(';');
                sb.append((String)codeParts[i]);
                ++i;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String addStateCode(StatecodingNode node) {
        Collection<EObject> eObjects = this.objectProvider.getEObjects(node.getClazz());
        int size = eObjects.size();
        if (size > 0) {
            Object[] codeParts = new String[size];
            int i = 0;
            for (EObject eObject : eObjects) {
                String code = this.addStateCode(node, eObject);
                codeParts[i++] = code;
            }
            Arrays.sort(codeParts);
            StringBuilder sb = new StringBuilder();
            sb.append((String)codeParts[0]);
            i = 1;
            while (i < codeParts.length) {
                sb.append(';');
                sb.append((String)codeParts[i]);
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String addStateCodeFromDependency(StatecodingDependency sd, EObject eObject) {
        if (sd.type.equals((Object)StatecodingDependencyType.NORMAL)) {
            Object eReferred = eObject.eGet((EStructuralFeature)sd.eReference);
            if (eReferred == null) {
                return "";
            }
            if (eReferred instanceof EList) {
                EList refferedList = (EList)eReferred;
                if (refferedList.isEmpty()) return "";
                Object[] codeParts = new String[refferedList.size()];
                int i = 0;
                for (Object referredEObject : refferedList) {
                    String code = this.addStateCode(sd.node, (EObject)referredEObject);
                    codeParts[i++] = code;
                }
                Arrays.sort(codeParts);
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                sb.append((String)codeParts[0]);
                i = 1;
                while (i < codeParts.length) {
                    sb.append(';');
                    sb.append((String)codeParts[i]);
                    ++i;
                }
                sb.append(']');
                return sb.toString();
            }
            if (!(eReferred instanceof EObject)) throw new DSEException("The EObject " + eObject.toString() + " does not have a feature " + eReferred.toString() + ".");
            return this.addStateCode(sd.node, (EObject)eReferred);
        }
        for (EObject dependentEObject : this.objectProvider.getEObjects(sd.node.getClazz())) {
            Object eReferred = dependentEObject.eGet((EStructuralFeature)sd.eReference);
            if (eReferred == null) continue;
            if (eReferred instanceof EList) {
                for (Object referredEObject : (EList)eReferred) {
                    if (!referredEObject.equals(eObject)) continue;
                    return this.addStateCode(sd.node, dependentEObject);
                }
                continue;
            }
            if (!eReferred.equals(eObject)) throw new DSEException("The EObject " + eObject.toString() + " does not have a feature " + eReferred.toString() + ".");
            return this.addStateCode(sd.node, dependentEObject);
        }
        return "";
    }
}

